/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.linea;

import java.util.ArrayList;
import java.util.List;

public class LineaProInformation {
    private List<String> mModelNodes = new ArrayList<String>();
    private byte[] mData;
    private String mSerialNumber;
    private String mManufacturer;
    private String mName;
    private String mModel;
    private String mVersion;

    private LineaProInformation(byte[] infoBytes) {
        int infoLen;
        this.mData = infoBytes;
        for (infoLen = 0; infoLen < infoBytes.length && infoBytes[infoLen] != 0; ++infoLen) {
        }
        ArrayList<String> infoList = new ArrayList<String>();
        int j = 0;
        for (int i = 0; i < infoLen; ++i) {
            if (infoBytes[i] == 124) {
                infoList.add(new String(infoBytes, j, i - j));
                j = ++i;
                continue;
            }
            if (i + 1 != infoLen) continue;
            infoList.add(new String(infoBytes, j, i - j + 1));
        }
        int infoListSize = infoList.size();
        if (infoListSize > 0) {
            this.mSerialNumber = (String)infoList.get(0);
        }
        if (infoListSize > 1) {
            this.mManufacturer = (String)infoList.get(1);
        }
        if (infoListSize > 2) {
            this.mName = (String)infoList.get(2);
        }
        if (infoListSize > 3) {
            this.mModel = (String)infoList.get(3);
        }
        if (infoListSize > 4) {
            this.mVersion = (String)infoList.get(4);
        }
        if (this.mModel != null) {
            for (int i = 0; i < (this.mModel.length() & 0xFFFFFFFE); i += 2) {
                String node = this.mModel.substring(i, i + 2);
                this.mModelNodes.add(node);
            }
        }
    }

    public static LineaProInformation create(byte[] data) {
        return new LineaProInformation(data);
    }

    public byte[] getData() {
        return this.mData;
    }

    public String getSerialNumber() {
        return this.mSerialNumber;
    }

    public String getManufacturer() {
        return this.mManufacturer;
    }

    public String getName() {
        return this.mName;
    }

    public String getModel() {
        return this.mModel;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public boolean hasOpticodeEngine() {
        return this.containsNode("1B") || this.containsNode("2B") || this.containsNode("XB");
    }

    public boolean hasNewlandEngine() {
        return this.containsNode("NB");
    }

    public boolean hasIntermecEngine() {
        return this.containsNode("IB");
    }

    public boolean hasBarcodeEngine() {
        return this.hasNewlandEngine() || this.hasOpticodeEngine() || this.hasIntermecEngine();
    }

    public boolean hasEncryptedMagneticHead() {
        return this.containsNode("CM") && this.containsNode("AM");
    }

    public boolean hasStandardMagneticHead() {
        return this.containsNode("PM");
    }

    public boolean hasMagneticHead() {
        return this.hasStandardMagneticHead() && this.hasEncryptedMagneticHead();
    }

    private boolean containsNode(String node) {
        for (String s : this.mModelNodes) {
            if (s.compareToIgnoreCase(node) != 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasExternalSpeaker() {
        return this.mName.equals("InfineaXS");
    }

    public boolean hasLED() {
        return this.mName.equals("InfineaXS");
    }
}

