/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.biometric;

import java.io.IOException;

public final class TouchChipException
extends IOException {
    private static final long serialVersionUID = 1L;
    private int mErrorCode;

    public TouchChipException() {
        this.mErrorCode = 0;
    }

    public TouchChipException(String message) {
        super(message);
        this.mErrorCode = 0;
    }

    public TouchChipException(int errorCode) {
        super(TouchChipException.getDescription(errorCode));
        this.mErrorCode = errorCode;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    private static String getDescription(int errorCode) {
        switch (errorCode) {
            case 0: {
                return "Success return status";
            }
            case -1: {
                return "Invalid command";
            }
            case -2: {
                return "Invalid command length";
            }
            case -3: {
                return "Identify error";
            }
            case -4: {
                return "Invalid command parameter";
            }
            case -5: {
                return "No data";
            }
            case -6: {
                return "Not enough internal memory for the requested operation";
            }
            case -7: {
                return "Duplication error";
            }
            case -1001: {
                return "General or unknown error status";
            }
            case -1002: {
                return "PerfectTrust API wasn't initialized";
            }
            case -1003: {
                return "PerfectTrust API has been already initialized";
            }
            case -1004: {
                return "Invalid parameter error";
            }
            case -1005: {
                return "Invalid handle error";
            }
            case -1006: {
                return "Not enough memory to process given operation";
            }
            case -1007: {
                return "Failure of external memory allocation function";
            }
            case -1008: {
                return "Passed data are too large";
            }
            case -1009: {
                return "Not enough permanent memory to store data";
            }
            case -1010: {
                return "There is more data to return than the supplied buffer can contain";
            }
            case -1033: {
                return "Function failed";
            }
            case -1036: {
                return "Invalid form of PT_INPUT_BIR structure";
            }
            case -1037: {
                return "TFM has returned wrong or unexpected response";
            }
            case -1038: {
                return "Not enough memory on TFM to process given operation";
            }
            case -1039: {
                return "Connection is already opened";
            }
            case -1040: {
                return "Cannot connect to TFM";
            }
            case -1041: {
                return "Timeout elapsed";
            }
            case -1042: {
                return "Bad biometric template";
            }
            case -1043: {
                return "Requested slot was not found";
            }
            case -1044: {
                return " Attempt to export anti spoofing info from TFM";
            }
            case -1045: {
                return "Attempt to import anti spoofing info to TFM";
            }
            case -1046: {
                return "Access to operation is denied";
            }
            case -1049: {
                return "No template was captured in current session";
            }
            case -1050: {
                return "Timeout for biometric operation has expired";
            }
            case -1051: {
                return "Failure of template consolidation";
            }
            case -1052: {
                return "Biometric operation canceled";
            }
            case -1053: {
                return "Authentication failed";
            }
            case -1054: {
                return "Unknown command";
            }
            case -1055: {
                return "Power off attempt failed";
            }
            case -1056: {
                return "Function or service is not implemented";
            }
            case -1057: {
                return "General communication error";
            }
            case -1058: {
                return "Session was terminated";
            }
            case -1059: {
                return "Touch chip error occurred";
            }
            case -1060: {
                return "I2C EEPROM error occurred";
            }
            case -1061: {
                return "Purpose parameter or BIR's purpose is invalid for given operation";
            }
            case -1062: {
                return "Finger swipe is too bad for image reconstruction";
            }
            case -1063: {
                return "Requested functionality or value of parameter is not supported";
            }
            case -1064: {
                return "Calibration failed";
            }
            case -1065: {
                return "Anti spoofing data were not captured";
            }
            case -1066: {
                return "Sensor latch-up event detected";
            }
            case -1067: {
                return "Diagnostics failed";
            }
            case -1068: {
                return "Attempt to upgrade to same firmware version";
            }
            case -1069: {
                return "No sensor";
            }
            case -1070: {
                return "The measured values are out of allowable limits";
            }
            case -1071: {
                return "Too many bad lines";
            }
            case -1072: {
                return "Sensor is not repairable";
            }
            case -1073: {
                return "Gain offset calibration error";
            }
            case -1074: {
                return "Asynchronous power shut down";
            }
            case -1075: {
                return "Attempt to upgrade to older firmware version";
            }
            case -1076: {
                return "Connection interrupted because of suspend request";
            }
            case -1077: {
                return "Device not found";
            }
            case -1078: {
                return "Device doesn't work as expected";
            }
            case -1079: {
                return "Host hardware doesn't support requested communication speed";
            }
            case -1080: {
                return "Sensor is not calibrated";
            }
            case -1081: {
                return "Firmware is missing or corrupted, device is running in safe mode";
            }
            case -1082: {
                return "Sensor hardware error occurred";
            }
            case -1083: {
                return "Session was not authenticated yet";
            }
            case -1084: {
                return "Secure channel has been already established";
            }
            case -1085: {
                return "Overflow of One Time Password sequence number";
            }
            case -1086: {
                return "General NVM error";
            }
            case -1087: {
                return "NVM write operation failed";
            }
            case -1088: {
                return "NVM read operation failed";
            }
            case -1089: {
                return "Attempt to access non-existing internal NVM file";
            }
            case -1090: {
                return "General crypto error";
            }
            case -1091: {
                return "Requested cryptographic mechanism is not supported";
            }
            case -1092: {
                return "Padding error detected during crypto operation";
            }
            case -1093: {
                return "Key too long case probably due to the export regulations";
            }
            case -1094: {
                return "Bad symmetric key used";
            }
            case -1095: {
                return "HW random number generator initialization failed";
            }
            case -1096: {
                return "Device is already opened for exclusive access by somebody else";
            }
            case -1097: {
                return "Used wrong finger data access rights";
            }
            case -1098: {
                return "Last match data don't exist";
            }
            case -1099: {
                return "No data found";
            }
            case -30001: {
                return "Generic error";
            }
            case -30002: {
                return "Memory allocation failure";
            }
            case -30003: {
                return "Bad parameter was provided";
            }
            case -30005: {
                return "Functionality is not supported by this library version";
            }
            case -30006: {
                return "Provided buffer is too small";
            }
            case -30007: {
                return "Unknown envelope type was provided or requested";
            }
            case -30008: {
                return "Unknown data type was provided or requested";
            }
            case -30009: {
                return "Error in input decoding";
            }
            case -30010: {
                return "Error in output encoding";
            }
            case -30011: {
                return "Error in data format";
            }
            case -30012: {
                return "Missing information";
            }
            case -30013: {
                return "Templates or images cannot be combined";
            }
            case -30099: {
                return "Internal error";
            }
        }
        return "Unspecify error code " + errorCode;
    }
}

