/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.barcode;

import com.datecs.barcode.IntermecBF4;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public abstract class Intermec {
    private static final int INTERMEC_ACK = 50;
    private static final int INTERMEC_DONE = 49;
    byte[] mReadBuffer = new byte[1024];
    int mReadBufferLen = 0;
    ByteArrayOutputStream mSettings = new ByteArrayOutputStream();

    protected abstract void init(byte[] var1) throws IOException;

    protected abstract void write(byte[] var1) throws IOException;

    protected abstract byte[] read() throws IOException;

    protected abstract void updateMode(byte[] var1) throws IOException;

    public void sendCommand(byte[] data) throws IOException {
        if (this.mSettings.size() == 0) {
            this.mSettings.write(65);
        }
        this.mSettings.write(data);
    }

    public void setPredefinedImagerSettings(int mode) throws IOException {
        byte[] data = new byte[]{64, 80, (byte)mode};
        this.sendCommand(data);
    }

    public void enableGlareDetection(boolean on) throws IOException {
        byte[] data = new byte[]{123, 88, (byte)(!on ? 1 : 0)};
        this.sendCommand(data);
    }

    public void setIlluminationLevel(int level) throws IOException {
        byte[] data = new byte[]{123, 70, (byte)level};
        if (level > 60) {
            throw new IllegalArgumentException("Value is outside limits");
        }
        this.sendCommand(data);
    }

    public void enableSymbology(int gid, int fid, boolean enable) throws IOException {
        byte[] data = new byte[]{(byte)gid, (byte)fid, (byte)(enable ? 1 : 0)};
        this.sendCommand(data);
    }

    public void enableAustralianPost(boolean enable) throws IOException {
        this.enableSymbology(52, 64, enable);
    }

    public void enableAztec(boolean enable) throws IOException {
        this.enableSymbology(83, 64, enable);
    }

    public void enableInfomail(boolean enable) throws IOException {
        this.enableSymbology(57, 64, enable);
    }

    public void enableCodabarl(boolean enable) throws IOException {
        this.enableSymbology(64, 64, enable);
    }

    public void enableCodablockA(boolean enable) throws IOException {
        this.enableSymbology(77, 64, enable);
    }

    public void enableCodablockF(boolean enable) throws IOException {
        this.enableSymbology(77, 65, enable);
    }

    public void enableCode11(boolean enable) throws IOException {
        this.enableSymbology(74, 64, enable);
    }

    public void enableCode39(boolean enable) throws IOException {
        this.enableSymbology(66, 64, enable);
    }

    public void enableCode93(boolean enable) throws IOException {
        this.enableSymbology(65, 64, enable);
    }

    public void enableCode128(boolean enable) throws IOException {
        this.enableSymbology(67, 64, enable);
    }

    public void enableGS1(boolean enable) throws IOException {
        this.enableSymbology(67, 66, enable);
    }

    public void enableISBT(boolean enable) throws IOException {
        this.enableSymbology(67, 65, enable);
    }

    public void enableDataMatrix(boolean enable) throws IOException {
        this.enableSymbology(84, 64, enable);
    }

    public void enableDutchPost(boolean enable) throws IOException {
        this.enableSymbology(54, 64, enable);
    }

    public void enableUPCA(boolean enable) throws IOException {
        this.enableSymbology(75, 64, enable);
    }

    public void enableUPCE(boolean enable) throws IOException {
        this.enableSymbology(75, 65, enable);
    }

    public void enableEAN13(boolean enable) throws IOException {
        this.enableSymbology(75, 67, enable);
    }

    public void enableEAN8(boolean enable) throws IOException {
        this.enableSymbology(75, 66, enable);
    }

    public void enableGS1CompositeAorB(boolean enable) throws IOException {
        this.enableSymbology(86, 64, enable);
    }

    public void enableGS1CompositeC(boolean enable) throws IOException {
        this.enableSymbology(86, 65, enable);
    }

    public void enableRSS14(boolean enable) throws IOException {
        this.enableSymbology(79, 64, enable);
    }

    public void enableGS1DatabarLimited(boolean enable) throws IOException {
        this.enableSymbology(79, 65, enable);
    }

    public void enableGS1DatabarExpanded(boolean enable) throws IOException {
        this.enableSymbology(79, 66, enable);
    }

    public void enableInterleaved2of5(boolean enable) throws IOException {
        this.enableSymbology(68, 64, enable);
    }

    public void enableJapanPost(boolean enable) throws IOException {
        this.enableSymbology(56, 64, enable);
    }

    public void enableMatrix2of5(boolean enable) throws IOException {
        this.enableSymbology(69, 64, enable);
    }

    public void enableMaxicode(boolean enable) throws IOException {
        this.enableSymbology(82, 64, enable);
    }

    public void enableMSICode(boolean enable) throws IOException {
        this.enableSymbology(70, 64, enable);
    }

    public void enableMulticode(boolean enable) throws IOException {
        this.enableSymbology(89, 64, enable);
    }

    public void enablePDF417(boolean enable) throws IOException {
        this.enableSymbology(76, 64, enable);
    }

    public void enableMicroPDF417(boolean enable) throws IOException {
        this.enableSymbology(76, 66, enable);
    }

    public void enablePlanet(boolean enable) throws IOException {
        this.enableSymbology(76, 64, enable);
    }

    public void enablePlesseyCode(boolean enable) throws IOException {
        this.enableSymbology(71, 64, enable);
    }

    public void enablePostnet(boolean enable) throws IOException {
        this.enableSymbology(48, 64, enable);
    }

    public void enableQRCode(boolean enable) throws IOException {
        this.enableSymbology(85, 64, enable);
    }

    public void enableStandard2of5(boolean enable) throws IOException {
        this.enableSymbology(72, 64, enable);
    }

    public void enableTelepen(boolean enable) throws IOException {
        this.enableSymbology(73, 64, enable);
    }

    public void enableTLC39(boolean enable) throws IOException {
        this.enableSymbology(78, 64, enable);
    }

    public void saveSymbology() throws IOException {
        byte[] data = this.mSettings.toByteArray();
        this.init(data);
        this.mSettings.reset();
    }

    private void write(byte[] buffer, int offset, int length) throws IOException {
        byte[] tmp = new byte[length];
        System.arraycopy(buffer, offset, tmp, 0, length);
        this.write(tmp);
    }

    private byte[] read(int count, int timeout) throws IOException {
        long endTime = System.currentTimeMillis() + (long)timeout;
        while (true) {
            if (System.currentTimeMillis() > endTime) {
                throw new IOException("Timeout");
            }
            if (this.mReadBufferLen >= count && count > 0 || this.mReadBufferLen > 0 && count == 0) {
                int toRead = this.mReadBufferLen;
                if (toRead > count && count > 0) {
                    toRead = count;
                }
                byte[] r = new byte[toRead];
                System.arraycopy(this.mReadBuffer, 0, r, 0, toRead);
                System.arraycopy(this.mReadBuffer, count, this.mReadBuffer, 0, this.mReadBufferLen - toRead);
                this.mReadBufferLen -= toRead;
                return r;
            }
            try {
                byte[] rcv = this.read();
                System.arraycopy(rcv, 0, this.mReadBuffer, this.mReadBufferLen, rcv.length);
                this.mReadBufferLen += rcv.length;
            }
            catch (IOException iOException) {
            }
        }
    }

    public byte[] query(byte[] command) throws IOException {
        this.write(command);
        byte[] r = this.read(0, 1000);
        return r;
    }

    private int calcCRC(byte[] data, int offset, int length) {
        int chk = 0;
        for (int i = 0; i < length; ++i) {
            chk += (data[i + offset] & 0xFF) * (length - i);
        }
        return chk;
    }

    private void downloadDriver(byte[] driver) throws IOException {
        this.write(new byte[]{-86});
        byte[] b = this.read(1, 1000);
        if ((b[0] & 0xFF) != 136) {
            throw new IOException("Invalid data received from engine");
        }
        int blocks = driver.length / 256;
        if (driver.length % 256 > 0) {
            ++blocks;
        }
        this.write(new byte[]{(byte)blocks});
        int blockNum = 1;
        while (blockNum < blocks) {
            b = this.read(2, 1000);
            if ((b[0] & 0xFF) != 128) {
                throw new IOException("Invalid data received from engine");
            }
            blockNum = b[1] & 0xFF;
            byte[] block = new byte[256];
            int offset = (blockNum - 1) * 256;
            int toWrite = driver.length - offset;
            if (toWrite > 256) {
                toWrite = 256;
            }
            System.arraycopy(driver, offset, block, 0, toWrite);
            this.write(block);
            b = this.read(1, 1000);
            if ((b[0] & 0xFF) != 127) {
                throw new IOException("Invalid data received from engine");
            }
            int chk = this.calcCRC(block, 0, block.length);
            block[0] = (byte)(chk >> 24);
            block[1] = (byte)(chk >> 16);
            block[2] = (byte)(chk >> 8);
            block[3] = (byte)(chk >> 0);
            this.write(block, 0, 4);
        }
        b = this.read(1, 1000);
        if ((b[0] & 0xFF) != 187) {
            throw new IOException("Invalid data received from engine");
        }
    }

    private void sendCommand(int command, byte[] data, boolean waitDone) throws IOException {
        byte[] buf = new byte[512];
        int index = 0;
        buf[index++] = 0;
        buf[index++] = (byte)command;
        if (data != null && data.length != 0) {
            System.arraycopy(data, 0, buf, index, data.length);
        }
        int chk = this.calcCRC(buf, 0, index += 8);
        buf[index++] = (byte)(chk >> 24);
        buf[index++] = (byte)(chk >> 16);
        buf[index++] = (byte)(chk >> 8);
        buf[index++] = (byte)(chk >> 0);
        this.write(buf, 0, index);
        byte[] b = this.read(1, 1000);
        if ((b[0] & 0xFF) != 50) {
            throw new IOException("Invalid data received from engine");
        }
        if (waitDone && ((b = this.read(1, 30000))[0] & 0xFF) != 49) {
            throw new IOException("Invalid data received from engine");
        }
    }

    private void setDownloadMode(boolean on) throws IOException {
        if (on) {
            this.updateMode(new byte[]{1});
        } else {
            this.updateMode(new byte[]{0});
        }
    }

    public void updateFirmware(byte[] firmware, ProgressListener listener) throws IOException {
        int size = firmware.length;
        if ((firmware[0] & 0xFF) != 51 || (firmware[1] & 0xFF) != 5 || (firmware[2] & 0xFF) != 97 || (firmware[3] & 0xFF) != 57 || (firmware[4] & 0xFF) != 152 || (firmware[5] & 0xFF) != 88) {
            throw new IllegalArgumentException("Firmware file wrong");
        }
        if (listener != null) {
            listener.onProgressUpdate("Initializing", 0);
        }
        this.setDownloadMode(true);
        try {
            int toWrite;
            int i;
            this.downloadDriver(IntermecBF4.LOADER);
            this.sendCommand(16, new byte[]{1}, true);
            this.sendCommand(17, null, false);
            byte[] b = this.read(4, 1000);
            int flashsize = (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | (b[3] & 0xFF) << 0;
            if (flashsize == 0) {
                throw new IOException("Incorrect loader for engine");
            }
            try {
                this.read(0, 100);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            int fwHeaderSize = 16;
            int fwnProducts = (firmware[6] & 0xFF) << 8 | firmware[7] & 0xFF;
            if (firmware.length - (fwHeaderSize += fwnProducts * 4) > flashsize) {
                throw new IOException("Firmware file wrong");
            }
            this.sendCommand(19, null, false);
            b = this.read(8, 1000);
            if (b.length < 8) {
                throw new IOException("Firmware version unable to read");
            }
            int devicepid = (b[4] & 0xFF) << 24 | (b[5] & 0xFF) << 16 | (b[6] & 0xFF) << 8 | (b[7] & 0xFF) << 0;
            try {
                this.read(0, 100);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            boolean found = false;
            for (i = 0; i < fwnProducts; ++i) {
                int offs = 8 + i * 4;
                int id = (firmware[offs + 0] & 0xFF) << 24 | (firmware[offs + 1] & 0xFF) << 16 | (firmware[offs + 2] & 0xFF) << 8 | (firmware[offs + 3] & 0xFF) << 0;
                if (devicepid != id) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new IOException("Device not found");
            }
            this.sendCommand(20, null, true);
            this.sendCommand(24, null, false);
            this.read(4, 1000);
            size -= fwHeaderSize;
            for (i = 0; i < size; i += toWrite) {
                toWrite = size - i;
                if (toWrite > 256) {
                    toWrite = 256;
                }
                int index = 0;
                byte[] block = new byte[275];
                block[index++] = 2;
                block[index++] = 0;
                block[index++] = 22;
                block[index++] = (byte)(toWrite >> 8);
                block[index++] = (byte)(toWrite >> 0);
                block[index++] = (byte)(i >> 24);
                block[index++] = (byte)(i >> 16);
                block[index++] = (byte)(i >> 8);
                block[index++] = (byte)(i >> 0);
                block[index++] = 0;
                block[index++] = 0;
                int chk = this.calcCRC(block, 1, index - 1);
                block[index++] = (byte)(chk >> 24);
                block[index++] = (byte)(chk >> 16);
                block[index++] = (byte)(chk >> 8);
                block[index++] = (byte)(chk >> 0);
                System.arraycopy(firmware, fwHeaderSize + i, block, index, toWrite);
                chk = this.calcCRC(block, index, toWrite);
                index += toWrite;
                block[index++] = (byte)(chk >> 24);
                block[index++] = (byte)(chk >> 16);
                block[index++] = (byte)(chk >> 8);
                block[index++] = (byte)(chk >> 0);
                byte[] tmp = new byte[index];
                System.arraycopy(block, 0, tmp, 0, tmp.length);
                this.updateMode(tmp);
                if (listener == null) continue;
                listener.onProgressUpdate("Writing", i * 100 / firmware.length);
            }
            this.sendCommand(18, null, true);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                this.setDownloadMode(false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (listener != null) {
            listener.onProgressUpdate("Complete", 100);
        }
    }

    public String getIdent() throws IOException {
        byte[] cmdVer = new byte[]{67, 48, -64};
        byte[] r = this.query(cmdVer);
        String barcodeIdent = "";
        int payloadLen = (r[3] & 0xFF) << 8 | r[4] & 0xFF;
        barcodeIdent = new String(r, 5, payloadLen);
        return barcodeIdent;
    }

    public static interface ProgressListener {
        public void onProgressUpdate(String var1, int var2);
    }
}

