﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime;

namespace FiscalPrinterSDK
{
    public enum TLanguage
    {
        English=0,
        Bulgarian=1
    }

    public class Errors_FiscalDevice
    {
        private string errorCode;
        private TLanguage lang; //= TLanguage.English;
        public Errors_FiscalDevice()
        {
            //
        }
        public TLanguage language
        {
            get
            {
                return this.lang;
            }
            set
            {
                this.lang = value;
            }
        } 

       
        
        //    Dictionary<string, string> fdErrors =
        //new Dictionary<string, string>();

        public readonly Dictionary<string, string[]> Errors = new Dictionary<string, string[]>
        {
            // (100000 - 100100) GENERIC ERRORS - FISCAL DEVICES
            // {"-1", new[] {"Enlish error","BG error" } },
            {"F", new[] { "Command is not executed successfully","Командата не се е изпълнила успешно"} } ,
            {"-23" , new[] {"Error occured in status bytes","Грешка, произлязла от статус битовете"} },
            //
            // Начало на кодове за статус битове (всички за C група)
            {"-24" , new[] {"Syntax error", "# Получените данни имат синктактична грешка"} },
            {"-25" , new[] { "# Command code is invalid","# Кодът на получената команда е невалиден" } },
            {"-26", new[] { "The real time clock is not synchronized", "Не е сверен часовника" } },
            {"-27", new[] { "0 Always 0", "Резервиран – винаги е 0" } },
            {"-28", new[] { "# Failure in printing mechanism", "Механизмът на печатащото устройство има неизправност"} },
            {"-29", new[] { "General error - this is OR of all errors marked with #", "Обща грешка - това е OR на всички грешки, маркирани с ‘#’"} },
            {"-30", new[] { "Cover is open", "Отворен е капакът на принтера"} },
            {"-31", new[] { "1 Always 1", "Резервиран – винаги е 1" } },
            {"-32", new[] { "# Command is not permitted", "# Изпълнението на командата не е позволено в текущия фискален режим"} },
            {"-33", new[] { "# Overflow during command execution", "# При изпълнение на командата се е получило препълване на някои полета от сумите"} },
            {"-34", new[] { "Nonfiscal receipt is open", "Отворен е служебен бон"} },
            {"-35", new[] { "EJ nearly full", "Близък край на КЛЕН" } },
            {"-36", new[] { "Fiscal receipt is open", "Отворен е фискален бон"} },
            {"-37", new[] { "EJ is full", "Край на КЛЕН (по-малко от 1 MB от КЛЕН свободни)"} },
            {"-38", new[] { "Near paper end", "Останала е малко хартия"} },
            {"-39", new[] { "# End of paper", "Свършила е хартията" } },
            {"-40", new[] { "Fiscal memory is not found or damaged", "Фискалната памет липсва или е повредена" } },
            {"-41", new[] { "OR of all errors marked with ‘*’ from Bytes 4 и 5", "OR на всички грешки, маркирани с ‘*’ от байтове 4 и 5" } },
            {"-42", new[] { "* Fiscal memory is full", "* Фискалната памет е пълна" } },
            {"-43", new[] { "There is space for less then 60 reports in Fiscal memory", "Има място за по-малко от 60 записа във ФП" } },
            {"-44", new[] { "Serial number and number of FM are set", "Зададени са индивидуален номер на ФУ и номер на ФП" } },
            {"-45", new[] { "Tax number is set", "Зададен е ЕИК" } },
            {"-46", new[] { "Error when trying to access data stored in the FM", "Грешка при запис във фискалната памет" } },
            {"-47", new[] { "VAT are set at least once", "Зададени са поне веднъж данъчните ставки" } },
            {"-48", new[] { "Device is fiscalized", "Устройството е във фискален режим" } },
            {"-49", new[] { "FM is formatted", "Фискалната памет е форматирана" } },
            // Допълнителни за Б група
            {"-50", new[] { "The built-in tax terminal is not responding", "Вграденият данъчен терминал не отговаря" } },
            {"-51", new[] { "Timeout, but there are unsent documents", "Има неизпратени документи за повече от настроеното време за предупреждение" } },
            {"-52", new[] { "There is space for less than 50 records remaining in the FP", "Има място за по-малко от 50 записа във ФП" } },
            {"-53", new[] { "Customer display is not installed", "Не е свързан клиентски дисплей" } },
            // Допълнителни за А група
            {"-54", new[] { "A service receipt with 90-degree rotated text printing is open", "Отворен е служебен бон за печата завъртян на 90 градуса текст" } },
            {"-55", new[] { "STORNO receipt is open", "Отворен сторно бон" } },
            {"-56", new[] { "# Low battery (the real-time clock is in RESET status).", "# Слаба батерия (Часовникът за реално време е в състояние RESET)" } },
            {"-57", new[] { "# The RAM has been reset", "# Извършено е зануляване на оперативната памет"} },
            {"-58", new[] { " The end of the EJ is very near (only certain receipts are allowed)", "Близък край на КЛЕН (само някои бонове са позволени)"} },
            {"-59", new[] { "Sw7 status", "Състояние на Sw7" } },
            {"-60", new[] { "Sw6 status", "Състояние на Sw6" } },
            {"-61", new[] { "Sw5 status", "Състояние на Sw5" } },
            {"-62", new[] { "Sw4 status", "Състояние на Sw4" } },
            {"-63", new[] { "Sw3 status", "Състояние на Sw3" } },
            {"-64", new[] { "Sw2 status", "Състояние на Sw2" } },
            {"-65", new[] { "Sw1 status", "Състояние на Sw1" } },
            {"-66", new[] { "The printing head is overheated", "Печатащата глава е прегряла" } },
            {"-67", new[] { "Fiscal memory read error", "Грешка при четене от фискалната памет" } },
            {"-68", new[] { "* The last fiscal memory store operation is not successful", "* Последният запис във фискалната памет не е успешен" } },
            {"-69", new[] { "* The fiscal memory is set in READONLY mode (locked)", "* Фискалната памет е установена в режим READONLY (заключена)." } },
            {"-70", new[] { "Not used", "Не се използва" } },
            // Край на кодове за статус битове 

            {"-100001" , new[] {"General error in fiscal device: In - out error( cannot read or write )","Основна грешка във фискалното устройство: Входно -  изходна грешка ( не може да прочете или запише )"}},
            {"-100002" , new[] {"General error in fiscal device: Wrong checksum","Основна грешка във фискалното устройство: Грешна чексума"}},
            {"-100003" , new[] {"General error in fiscal device: No more data","Основна грешка във фискалното устройство: Няма повече данни"}},
            {"-100004" , new[] {"General error in fiscal device: The element is not found","Основна грешка във фискалното устройство: Търсеният елемент не е намерен"}},
            {"-100005" , new[] {"General error in fiscal device: There are no records found","Основна грешка във фискалното устройство: Няма открити записи"}},
            {"-100006" , new[] {"General error in fiscal device: The operation is aborted","Основна грешка във фискалното устройство: Операцията е прекъсната"}},
            {"-100007" , new[] {"Wrong mode( standart, training...)  is selected.","Избран е грешен режим."}},
            {"-100008" , new[] {"General error in fiscal device: Device is not ready","General error in fiscal device: Device is not ready"}},
            {"-100009" , new[] {"General error in fiscal device: Nothing to print","Основна грешка във фискалното устройство: Няма нищо за печат"}},


            {"-100100" , new[] {"Fiscal memory error: Fiscal memory is busy","Грешка във фискалната памет: Фискалната памет е заета"}},
            {"-100101" , new[] {"Fiscal memory error: Fiscal memory failure. Could not read or write","Грешка във фискалната памет: Неуспешен запис във фискалната памет."}},
            {"-100102" , new[] {"Fiscal memory error: Forbidden write in fiscal memory","Грешка във фискалната памет: Забранен запис във фискалната памет"}},
            {"-100103" , new[] {"Fiscal memory error: Wrong address in fiscal memory","Грешка във фискалната памет: Грешен адрес във фискалната памет"}},
            {"-100104" , new[] {"Fiscal memory error: Wrong size in fiscal memory","Грешка във фискалната памет: Грешен размер във фискалната памет"}},
            {"-100105" , new[] {"Fiscal memory error: Fiscal memory is not connected","Грешка във фискалната памет: Фискалната памет не е свързана"}},
            {"-100106" , new[] {"Fiscal memory error: Wrong checksum in fiscal memory( invalid data )","Грешка във фискалната памет: Грешна чексума на фискалната памет( невалидни данни )"}},
            {"-100107" , new[] {"Fiscal memory error: Empty block in fiscal memory","Грешка във фискалната памет: Празен блок във фискалната памет"}},
            {"-100108" , new[] {"Fiscal memory error: Maximum number of block  in fiscal memory","Грешка във фискалната памет: Максимален размер на блок във фискалната памет"}},
            {"-100109" , new[] {"Fiscal memory error: Wrong range in fiscal memory","Грешка във фискалната памет: Грешен обхват във фискалната памет"}},
            {"-100110" , new[] {"Fiscal memory error: Empty range in fiscal memory","Грешка във фискалната памет: Празен обхват във фискалната памет"}},
            {"-100111" , new[] {"Fiscal memory error: New module in fiscal memory","Грешка във фискалната памет: Нов модул във фискалната памет"}},
            {"-100112" , new[] {"Fiscal memory error: Fiscal memory is not empty","Грешка във фискалната памет: Фискалната памет не е празна"}},
            {"-100113" , new[] {"Fiscal memory error: Fiscal memory is not equal","Грешка във фискалната памет: Фискалната памет не е същата"}},
            {"-100114" , new[] {"Fiscal memory error: Fiscal memory is full","Грешка във фискалната памет: Фискалната памет е пълна"}},
            {"-100115" , new[] {"Fiscal memory error: Fiscal memory needs update","Грешка във фискалната памет: Необходим е ъпдейт на фискалната памет"}},
            {"-100116" , new[] {"Fiscal memory error: Fiscal memory is blocked","Грешка във фискалната памет: Фискалната памет е блокирана"}},


            {"-100400" , new[] {"Line thermal printer mechanism error: Power supply error ( 3,3 V )","Грешка в печатащия механизъм: Проблем със захранването ( 3,3 В )"}},
            {"-100401" , new[] {"Line thermal printer mechanism error: Power supply error ( 24V or 8V )","Грешка в печатащия механизъм: Проблем с голямото захранване ( 24В или 8В )"}},
            {"-100402" , new[] {"Line thermal printer mechanism error: Head overheating","Грешка в печатащия механизъм: Прегряване на главата"}},
            {"-100403" , new[] {"Line thermal printer mechanism error: Paper end","Грешка в печатащия механизъм: Край на хартията"}},
            {"-100404" , new[] {"Line thermal printer mechanism error: Cover is open","Грешка в печатащия механизъм: Отворен капак"}},
            {"-100405" , new[] {"Line thermal printer mechanism error: Near paper end","Грешка в печатащия механизъм: Близък край на хартията"}},
            {"-100406" , new[] {"Line thermal printer mechanism error: Mark sensor - not used","Грешка в печатащия механизъм: Марк сензор ( за етикети ) не се ползва"}},
            {"-100407" , new[] {"Line thermal printer mechanism error: Cutter error","Грешка в печатащия механизъм: Грешка в кътера"}},
            {"-100408" , new[] {"Line thermal printer mechanism error: Not used","Грешка в печатащия механизъм: Не се ползва"}},
            {"-100409" , new[] {"Line thermal printer mechanism error: Not used","Грешка в печатащия механизъм: Не се ползва"}},
            {"-100410" , new[] {"Line thermal printer mechanism error: Not used","Грешка в печатащия механизъм: Не се ползва"}},
            {"-100411" , new[] {"Line thermal printer mechanism error: Not used","Грешка в печатащия механизъм: Не се ползва"}},
            {"-100412" , new[] {"Line thermal printer mechanism error: Not used","Грешка в печатащия механизъм: Не се ползва"}},
            {"-100413" , new[] {"Line thermal printer mechanism error: Not used","Грешка в печатащия механизъм: Не се ползва"}},
            {"-100414" , new[] {"Printer on time is overrun.","Времето за непрекъсната работа на печ. механизъм е надхвърлено. След изтичане на фиксирано време за почивка грешката ще изчезне."}},


            {"-100500" , new[] {"System error: Memory structure error","Системна грешка: Грешка в структурата на паметта"}},
            {"-100501" , new[] {"System error: Error in RAM","Системна грешка: Грешка в рама"}},
            {"-100502" , new[] {"System error: Flash memory error","Системна грешка: Грешка във флаш паметта"}},
            {"-100503" , new[] {"System error: SD card error","Системна грешка: Грешка в SD картата"}},
            {"-100504" , new[] {"System error: Invalid message file","Системна грешка: Грешен файл със съобщения"}},
            {"-100505" , new[] {"System error: Fiscal memory error( could not write or read )","Системна грешка: Грешка във фискалната памет( неуспешен запис или четене )"}},
            {"-100506" , new[] {"System error: No RAM battery","Системна грешка: Няма РАМ батерия"}},
            {"-100507" , new[] {"System error: SAM module error","Системна грешка: Грешка в САМ модула"}},
            {"-100508" , new[] {"System error: Real time clock error","Системна грешка: Грешка в системния часовник"}},
            {"-100509" , new[] {"System error: Memory error","Системна грешка: Грешка в паметта"}},
            {"-100510" , new[] {"System error: The size of SD card is wrong.","System error: The size of SD card is wrong."}},
            {"-100511" , new[] {"System error: TPM module error","Системна грешка: Грешка в TPM модула"}},


            {"-101000" , new[] {"Common logical error: No heap memory( cannot allocate memory for operation )","Обща логическа грешка: Няма хийп памет( не може да се зареди памет за изпълнение на операцията )"}},
            {"-101001" , new[] {"Common logical error: File manipulate error","Обща логическа грешка: Грешка в операция с файлове"}},
            {"-101003" , new[] {"Common logical error: Operation is rejected","Обща логическа грешка: Действието е отхвърлено"}},
            {"-101004" , new[] {"Common logical error: Bad input. Some of the data or parameters are incorrect","Обща логическа грешка: Грешни входни данни. Някои от данните или параметрите са неправилни"}},
            {"-101005" , new[] {"Common logical error: In Application Programming error","Обща логическа грешка: Вътрешно- програмна грешка"}},
            {"-101006" , new[] {"Common logical error: The execution of the operation is not possible","Обща логическа грешка: Изпълнението на операцията е невъзможно"}},
            {"-101007" , new[] {"Common logical error: Timeout. The time for waiting execution is out","Обща логическа грешка: Таймаут. Времето за чакане на изпълнение е изтекло"}},
            
            // 

            {"-101008" , new[] {"Common logical error: Invalid time","Обща логическа грешка: Невалиден час"}},
            {"-101009" , new[] {"Common logical error: The operation is cancelled","Обща логическа грешка: Операцията е отказана"}},
            {"-101010" , new[] {"Common logical error: Invalid format","Обща логическа грешка: Невалиден формат"}},
            {"-101011" , new[] {"Common logical error: Invalid data","Обща логическа грешка: Невалидни данни"}},
            {"-101012" , new[] {"Common logical error: Data parsing error","Обща логическа грешка: Грешка при парсване"}},
            {"-101013" , new[] {"Common logical error: Hardware configuration error","Обща логическа грешка: Грешка в конфигурацията на хардуера"}},
            {"-101014" , new[] {"ERR_ACCESS_DENIED","ERR_ACCESS_DENIED"}},
            {"-101015" , new[] {"Wrong data length","Грешна дължина на входните данни"}},
            {"-101016" , new[] {"Error during verification of Z reports","Грешка при верификация на Z отчетите"}},
            {"-101017" , new[] {"Common logical error:  No permission","Обща логическа грешка: Няма разрешение"}},

            {"-101500" , new[] {"Update error: No update. The device is up to date","Грешка от ъпдейт: Няма ъпдейт. Устройството е актуално"}},
            {"-101501" , new[] {"Update error: Update is already in progress","Грешка при актуализирането: Актуализацията е в процес на изпълнение"}},

            {"-102000" , new[] {"Battery error: Low battery","Грешка в батерията: Ниско захранване на батерията"}},
            {"-102001" , new[] {"Battery error: Low battery warning","Грешка в батерията: Предупреждение за ниско захранване на батерията"}},
            {"-102002" , new[] {"Operator error: Wrong operator password","Операторска грешка: Грешна парола на оператор"}},
            {"-102003" , new[] {"ECR error: ID number is empty","Грешка на касовия апарат: ID номера на устройството е празен"}},
            {"-102004" , new[] {"Bluetooth error: Bluetooth is not found","Блутуут грешка: Не е намерен блутуут"}},
            {"-102005" , new[] {"Display error: Display is not connected","Грешка в дисплея: Дисплея не е свързан"}},
            {"-102006" , new[] {"Printer error: Printer is not connected","Грешка в принтера: Принтера не е свързан"}},
            {"-102007" , new[] {"SD card error: SD card not present","Грешка в SD картата: Няма SD карта"}},
            {"-102008" , new[] {"SD card error: SD2 card not present","Грешка в SD картата: Няма SD2 карта"}},
            {"-102009" , new[] {"ECR error: VAT rates is not set.","Грешка на касовия апарат: Данъчните ставки не са зададени."}},
            {"-102010" , new[] {"ECR error: Header lines are empty.","Грешка на касовия апарат: Редовете на клишето не са попълнени."}},
            {"-102011" , new[] {"User is registered by VAT, but number of the user is not entered.","Потребителя е регистриран по ДДС, но не е въвел ЗДДС номер"}},
            {"-102012" , new[] {"ECR error: FM number is empty","Грешка на касовия апарат: FM номера на устройството е празен"}},
            {"-102013" , new[] {"ECR error: Serviceman name is empty","Грешка на касовия апарат: Името на сервизния техник е празено"}},
            {"-102014" , new[] {"ECR error: Serviceman ID is empty","Грешка на касовия апарат: ID номера на сервизния техник е празен"}},
            {"-102015" , new[] {"ECR error: Tax office ID is empty!","Грешка на касовия апарат: ID на данъчния офис е празен"}},
            {"-102016" , new[] {"ECR error: Wrong format","Грешка на касовия апарат: Грешен формат на параметъра"}},
            {"-102017" , new[] {"ECR error: TAX number is empty","Грешка на касовия апарат: Данъчния номер е празен"}},
            {"-102018" , new[] {"ECR error: ID number is wrong","Грешка на касовия апарат: Грешен ID номер"}},
            {"-102019" , new[] {"ECR error: Date and time are earlier than date and time of previous Z report.","Грешка на касовия апарат: Датата и часа са по ранни от тезни на предходния Z отчет."}},
            {"-102020" , new[] {"ECR error: The software password is not entered","Грешка на касовия апарат: Не е въведена парола на софтуера"}},
            {"-102021" , new[] {"ECR error: ID number is empty","Грешка на касовия апарат: IOSA номера на устройството е празен"}},

            {"-103000" , new[] {"PLU database error: PLU database is not found","Грешка в базата данни на артикули: Не е намерена базата данни с артикули"}},
            {"-103001" , new[] {"PLU database error: PLU code already exists","Грешка в базата данни на артикули: Артикул с такъв код съществува"}},
            {"-103002" , new[] {"PLU database error: Barcode already exists","Грешка в базата данни на артикули: Съществува артикул с такъв баркод"}},
            {"-103003" , new[] {"PLU database error: PLU database is full","Грешка в базата данни на артикули: Базата с данни за артикулите  е пълна"}},
            {"-103004" , new[] {"PLU database error: PLU has turnover","Грешка в базата данни на артикули: Артикулът има оборт"}},
            {"-103005" , new[] {"PLU database error: In the PLU base has an article with same name.","Грешка в базата данни на артикули: В базате има артикул с такова име."}},
            {"-103006" , new[] {"PLU database error: PLU name is not unique.","Грешка в базата данни на артикули: Името на артикула не е уникално."}},
            {"-103007" , new[] {"PLU database error: Database format is not compatible.","Грешка в базата данни на артикули: Форматът на базата данни е несъвместим."}},
            {"-103008" , new[] {"Can't open the PLU database file","Не може да отвори файла с базата на артикулите"}},

            {"-104000" , new[] {"Service operation error: Z report is needed for this operation","Грешка от сервизна операция: Необходим е Z отчет за тази операция"}},
            {"-104001" , new[] {"Service operation error: Service jumper is needed for this operation","Грешка от сервизна операция: Необходим е сервизен джъмпер за тази операция"}},
            {"-104002" , new[] {"Service operation error: Service password is needed for this operation","Грешка от сервизна операция: Необходима е сервизна парола за тази операция"}},
            {"-104003" , new[] {"Service operation error: The operation is forbidden","Грешка от сервизна операция: Операцията е забранена"}},
            {"-104004" , new[] {"Service operation error: Service intervention is needed","Грешка от сервизна операция: Необходима е сервизна намеса"}},
            {"-104005" , new[] {"Service operation error: All clearing report is needed.","Грешка от сервизна операция: Необходими са всички отчети с нулиране."}},
            {"-104006" , new[] {"Service operation error: Z report closed.","Грешка от сервизна операция: Z отчетът е затворен."}},
            {"-104007" , new[] {"Service operation error: Montly report needed.","Грешка от сервизна операция: Необходим е месечен отчет."}},
            {"-104008" , new[] {"Service operation error: Year report needed.","Грешка от сервизна операция: Необходим е годишен отчет."}},
            {"-104009" , new[] {"Service operation error: Backup needed.","Грешка от сервизна операция: Необходим е бекъп."}},
            {"-104010" , new[] {"ERR_NEED_ALL_PAIDOUT","ERR_NEED_ALL_PAIDOUT"}},
            {"-104011" , new[] {"Clearing report for operator is needed.","Необходимо е да се направи отчет по оператори с нулиране."}},
            {"-104012" , new[] {"Clearing report for item group is needed.","Необходимо е да се направи отчет по стокови групи с нулиране."}},
            {"-104013" , new[] {"VAT changes is needed.","Необходима е смяна на данъчните ствки."}},

            {"-105000" , new[] {"EJ error: No records in EJ","Грешка в електронния журнал: Няма записи в електронния журнал"}},
            {"-105001" , new[] {"EJ error: Cannot add to EJ","Грешка в електронния журнал: Не може да се добави в електронния журнал"}},
            {"-105002" , new[] {"EJ error: SAM module signature error","Грешка в електронния журнал: Грешка в подписа от САМ модула"}},
            {"-105003" , new[] {"EJ error: Signature key version is changed -> impossible check","Грешка в електронния журнал: Сменена е версията на ключа на подписа -> невъзможна проверка"}},
            {"-105004" , new[] {"EJ error: Bad record in EJ","Грешка в електронния журнал: Невалиден запис в електронния журнал"}},
            {"-105005" , new[] {"EJ error: Generate signature error( cannoct generate signature )","Грешка в електронния журнал: Грешка при генериране на подпис"}},
            {"-105006" , new[] {"EJ error: Wrong type of document to sign","Грешка в електронния журнал: Грешен тип документ за подпис"}},
            {"-105007" , new[] {"EJ error: Document is already signed","Грешка в електронния журнал: Документа вече е подписан"}},
            {"-105008" , new[] {"EJ error: EJ is not from this device","Грешка в електронния журнал: Електронния журнал не е от това устройство"}},
            {"-105009" , new[] {"EJ error: EJ is almost full","Грешка в електронния журнал: Електронния журнал е почти пълен"}},
            {"-105010" , new[] {"EJ error: EJ is full","Грешка в електронния журнал: Електронния журнал е пълен"}},
            {"-105011" , new[] {"EJ error: Wrong format of EJ","Грешка в електронния журнал: Грешен формат на електронния журнал"}},
            {"-105012" , new[] {"The electronic journal is not ready.","Електронния журнал не готов за работа."}},
            {"-105013" , new[] {"Error in EJ structure. Create new one.","Грешка в журнала. Създайте нов."}},

            {"-106000" , new[] {"Client database error: Firm does not exist","Грешка в клиентската база данни: Фирмата не съществува"}},
            {"-106001" , new[] {"Client database error: Firmcode already exists","Грешка в клиентската база данни: Кодът на фирмата вече съществува"}},
            {"-106002" , new[] {"Client database error: EIK already exists","Грешка в клиентската база данни: ЕИК вече съществува"}},
            {"-106003" , new[] {"Client database error: Firm database is full","Грешка в клиентската база данни: Базата от данни за фирмите е пълна"}},
            {"-106004" , new[] {"Client database error: Firm database is not found","Грешка в клиентската база данни: Не е намерена базата от данни за фирмите"}},

            {"-107001" , new[] {"Invalid certificate.","Невалиден сертификат"}},
            {"-107002" , new[] {"Certificate exist.","Съществува вече валиден сертификат"}},
            {"-107003" , new[] {"Certificate unpack failed.","'Разопаковане' на сертификате е неуспешно"}},
            {"-107004" , new[] {"Wrong certificate password.","Грешна парола"}},
            {"-107005" , new[] {"File write error.","Грешка в записа на файл"}},
            {"-107006" , new[] {"File read error.","Грешка при четене от файл"}},
            {"-107007" , new[] {"Certificate not found.","Сертификата не съществува"}},

            {"-107500" , new[] {"he current account has expired!","Текущият профил е изтекъл!"}},
            {"-107501" , new[] {"Invalid profile file!","Невалиден profile файл!"}},
            {"-107502" , new[] {"Profile start date is invalid!","Началната дата на профила е невалидна!"}},
            {"-107503" , new[] {"Profile verification fail!","Проверката на профила не е успешна!"}},
            {"-107504" , new[] {"Wrong profile struct format","Грешна структура на профила"}},

            {"-108000" , new[] {"Discount card database error: Discount card does not exist","Грешка в базата данни за карти за отстъпка: Картата за отстъпка не съществува"}},
            {"-108001" , new[] {"Discount card database error: Discount card already exists","Грешка в базата данни за карти за отстъпка: Картата за отстъпка вече съществува"}},
            {"-108002" , new[] {"Discount card database error: Barcode already exists","Грешка в базата данни за карти за отстъпка: Съществува карта за отстъпки с такъв баркод"}},
            {"-108003" , new[] {"Discount card database error: Discount card database is full","Грешка в базата данни за карти за отстъпка: Базата с картати за отстъпка е пълна"}},
            {"-108004" , new[] {"Discount card database error: Discount card not found","Грешка в базата данни за карти за отстъпка: Картата за отстъпка не е намерена"}},

            {"-109981" , new[] {"Smartcard error: No card in the holder.","Грешка при работа със смарт картата: Няма карта в холдера."}},
            {"-109982" , new[] {"Smartcard error: Configuration failed","Грешка при работа със смарт картата: Неуспешно конфигуриране."}},
            {"-109983" , new[] {"Smartcard error: SmartCard communication error.","Грешка при работа със смарт картата: Грешка при комуникация със смарт картата."}},
            {"-109984" , new[] {"Smartcard error: Supply voltage drop, a VCC over-current detection or overheating.","Грешка при работа със смарт картата: Supply voltage drop, a VCC over-current detection or overheating."}},
            {"-109985" , new[] {"Smartcard error: Unexpected response from the applet.","Грешка при работа със смарт картата: Неочакван отговор от аплета."}},
            {"-109986" , new[] {"The ID of the smart card does not match the ID stored in the fiscal memory.","ID-то на смарт картата не съвпада с ID-то записано във фискалната памет."}},

            {"-110000" , new[] {"SAM module error: SAM init error","Грешка в САМ модула: Грешка при инициализацията на САМ модула"}},
            {"-110001" , new[] {"SAM module error: Error, while trying to open SAM module with programmed serial number","Грешка в САМ модула: Грешка при отваряне на САМ-а с програмирания сериен номер"}},
            {"-110002" , new[] {"SAM module error: Opening SAM with empty ID","Грешка в САМ модула: Отваряне на САМ с празно ID"}},
            {"-110003" , new[] {"SAM module error: SAM select file error","Грешка в САМ модула: Грешка в САМ модула при избора на файл"}},
            {"-110004" , new[] {"SAM module error: SAM init telegram error","Грешка в САМ модула: Грешка в САМ модула при инициализиране на телеграма"}},
            {"-110005" , new[] {"SAM module error: SAM is already open","Грешка в САМ модула: САМ модула вече е стартиран"}},
            {"-110006" , new[] {"SAM module error: SAM communication error","Грешка в САМ модула: Грешка в комуникацията на САМ модула"}},
            {"-110010" , new[] {"SAM module error: Operation execution in SAM module is unsuccessful","Грешка в САМ модула: Неуспешно изпълнение на операция в САМ"}},
            {"-110011" , new[] {"SAM module error: Cannot get last transaction from SAM","Грешка в САМ модула: Неуспешно извличане на последната транзакция от САМ"}},
            {"-110012" , new[] {"SAM module error: Cannot register current transaction in SAM","Грешка в САМ модула: Неуспешно регистриране на текущата транзакция в САМ"}},
            {"-110013" , new[] {"SAM module error: Cannot get Z-report from SAM","Грешка в САМ модула: Неуспешно извличане на Z-отчет от САМ"}},
            {"-110014" , new[] {"SAM module error: Cannot register Z-report in SAM","Грешка в САМ модула: Неуспешно регистриране на Z-отчет в САМ"}},
            {"-110021" , new[] {"SAM module error: Transaction is closed in SAM -> 'closing needed'","Грешка в САМ модула: Транзакцията е затворена в sam -> 'closing needed'"}},
            {"-110022" , new[] {"SAM module error: Z-report already closed in SAM -> 'Z needed'","Грешка в САМ модула: Z-отчетът е затворен в sam -> 'Z needed'"}},
            {"-110023" , new[] {"SAM module error: Unsent Z-reports -> 'communication needed'","Грешка в САМ модула: Има неизпратени Z -> 'communication needed'"}},
            {"-110024" , new[] {"SAM module error: Overflow in reg -> 'Z needed'","Грешка в САМ модула: Има препълване в РЕГ -> 'Z needed'"}},
            {"-110025" , new[] {"SAM module error: Not opened( empty ) Z - report -> 'Z impossible'","Грешка в САМ модула: Неотворен(празен) Z - отчет -> 'Z impossible'"}},

            {"-110100" , new[] {"Device error: Communication error","Грешка в устройството: Грешка в комуникацията"}},
            {"-110101" , new[] {"Device error: Wrong struct format","Грешка в устройството: Грешен формат на структурата"}},
            {"-110102" , new[] {"Device error: ST flag is active","Грешка в устройството: ST флага е активен"}},
            {"-110103" , new[] {"Device error: Invalid data","Грешка в устройството: Невалидни данни"}},
            {"-110104" , new[] {"Device error: Device is not fiscalized","Грешка в устройството: Устройството не е фискализирано"}},
            {"-110105" , new[] {"Device error: Device is already fiscalized","Грешка в устройството: Устройството вече е фискализирано"}},
            {"-110106" , new[] {"Device error: Device is in service mode","Грешка в устройството: Устройството е в сервизен режим"}},
            {"-110107" , new[] {"Device error: Service date is passed","Грешка в устройството: Сервизната дата е минала"}},
            {"-110108" , new[] {"Device error: Day( shift ) is open","Грешка в устройството: Денят( смяната ) е започнала"}},
            {"-110109" , new[] {"Device error: Day( shift ) is closed","Грешка в устройството: Денят( смяната ) е риключила"}},
            {"-110110" , new[] {"Device error: Z-report number and shift number are not equal","Грешка в устройството: Не съвпадат номерата на смяната и Z-отчета"}},
            {"-110111" , new[] {"Device error: Only admin has permition","Грешка в устройството: Само администратор има права"}},
            {"-110112" , new[] {"Device error: Fiscal memory is closed","Грешка в устройството: Фискалната памет е затворена"}},

            {"-110200" , new[] {"NAP server error: Error open session","Грешка при комуникация със сървъра на НАП: Грешка при започване на сесия"}},
            {"-110201" , new[] {"NAP server error: Error preparing data for server","Грешка при комуникация със сървъра на НАП: Грешка в данните за сървъра"}},
            {"-110202" , new[] {"NAP server error: There is unsent data","Грешка при комуникация със сървъра на НАП: Има неизпратени данни"}},
            {"-110203" , new[] {"NAP server error: Receiving data error","Грешка при комуникация със сървъра на НАП: Грешка при приемане"}},
            {"-110204" , new[] {"NAP server error: Empty data","Грешка при комуникация със сървъра на НАП: Няма данни"}},
            {"-110205" , new[] {"NAP server error: Server negative answer","Грешка при комуникация със сървъра на НАП: Сървърът връща грешка"}},
            {"-110206" , new[] {"NAP server error: Wrong answer format","Грешка при комуникация със сървъра на НАП: Грешен формат на отговора"}},
            {"-110207" , new[] {"NAP server error: Server HOSTDI is zerro","Грешка при комуникация със сървъра на НАП: HOSTDI на сървъра е нула"}},
            {"-110208" , new[] {"NAP server error: Server exception","Грешка при комуникация със сървъра на НАП: Грешка от сървъра"}},
            {"-110209" , new[] {"NAP server error: Not registered on server","Грешка при комуникация със сървъра на НАП: Не е регистриран на сървъра"}},

            {"-110210" , new[] {"NAP server error: Communication with NAP server is blocked","Грешка при комуникация със сървъра на НАП: Блокирана връзка с НАП"}},
            {"-110211" , new[] {"NAP server error: Modem error","Грешка при комуникация със сървъра на НАП: Грешка в модема"}},
            {"-110212" , new[] {"NAP server error: NAP is busy","Грешка при комуникация със сървъра на НАП: В момента сървъра е зает"}},
            {"-110213" , new[] {"NAP server error: Already registered","Грешка при комуникация със сървъра на НАП: Вече е регистриран"}},
            {"-110214" , new[] {"NAP server error: Wrong PS type","Грешка при комуникация със сървъра на НАП: Грешен 'Тип на обекта'"}},
            {"-110215" , new[] {"NAP server error: Deregistered in NAP","Грешка при комуникация със сървъра на НАП: Дерегистриран в НАП"}},
            {"-110216" , new[] {"NAP server error: Wrong IMSI number","Грешка при комуникация със сървъра на НАП: Грешен IMSI номер"}},
            {"-110217" , new[] {"NAP server error: Device is blocked( maximum Z-reports )","Грешка при комуникация със сървъра на НАП: Устройството е блокирано( максимален брой Z - отчети )"}},
            {"-110218" , new[] {"NAP server error: Wrong FD( Fiscal device ) type","Грешка при комуникация със сървъра на НАП: Грешен тип на фискалното устройство"}},
            {"-110219" , new[] {"NAP server error: The ECR is blocked by server","Грешка при комуникация със сървъра на НАП: Устройството е блокирано от сървъра"}},
            {"-110220" , new[] {"NAP server error: The ECR is blocked - server error","Грешка при комуникация със сървъра на НАП: Устройството е блокирано - грешка от сървъра"}},
            {"-110221" , new[] {"NAP server error: No server address","Грешка при комуникация със сървъра на НАП: Няма адрес на сървър"}},
            {"-110222" , new[] {"NAP server error: Max. registrations reached.","Грешка при комуникация със сървъра на НАП: Достигнат максимален брой регистрации."}},
            {"-110223" , new[] {"Invalid INN of the cashier","Невалиден ИНН номер на касиера."}},
            {"-110224" , new[] {"Invalid INN of the server","Невалиден ИНН номер на сървър"}},
            {"-110225" , new[] {"NAP server error: Device is blocked( unsent sales documents )","Грешка при комуникация със сървъра на НАП: Устройството е блокирано( неизпратени документи за продажба )"}},
            {"-110226" , new[] {"NAP server error: Communication with NAP server is blocked. More than 24 hours from last sent receipt.","Грешка при комуникация със сървъра на НАП: Блокирана връзка с НАП. Изминали са повече от 24 часа от последно изпратената бележка."}},

            {"-110300" , new[] {"Working error: Invalid file","Работна грешка: Грешни данни"}},
            {"-110301" , new[] {"Working error: Invalid parameters","Работна грешка: Грешни параметри"}},

            {"-110400" , new[] {"Connection error: Connection init error","Комуникационна грешка: Грешка в инициализацията на връзка"}},
            {"-110401" , new[] {"NRA connection error: Wrong parameteres","Комуникационна грешка: Грешни параметри"}},
            {"-110402" , new[] {"NRA connection error: No GPRS","Комуникационна грешка: Няма GPRS"}},
            {"-110403" , new[] {"Connection error: Failed to initialize connection with NRA Repository Server","Комуникационна грешка: Грешка в инициализацията на връзка със сървъра хранилище на НАП"}},
            {"-110404" , new[] {"Connection error: Wrong answer format","Комуникационна грешка: Грешен формат на отговора от сървъра"}},
            {"-110405" , new[] {"Connection error: Wrong configuration","Комуникационна грешка: Грешни настройки."}},
            {"-110410" , new[] {"Connection error: Procedure I01 is needed","Connection error: Procedure I01 is needed"}},
            {"-110411" , new[] {"Connection error: Procedure I02 is needed","Connection error: Procedure I02 is needed"}},
            {"-110412" , new[] {"Connection error: Procedure I03 is needed","Connection error: Procedure I03 is needed"}},
            {"-110413" , new[] {"Connection error: Procedure I04 is needed","Connection error: Procedure I04 is needed"}},
            {"-110414" , new[] {"Connection error: Procedure I05 is needed","Connection error: Procedure I05 is needed"}},
            {"-110415" , new[] {"Connection error: Procedure I06 is needed","Connection error: Procedure I06 is needed"}},
            {"-110416" , new[] {"Connection error: Procedure I07 is needed","Connection error: Procedure I07 is needed"}},
            {"-110417" , new[] {"Connection error: Procedure I08 is needed","Connection error: Procedure I08 is needed"}},
            {"-110418" , new[] {"Maximum number of unsent Z reports reached!","Maximum number of unsent Z reports reached!"}},
            {"-110419" , new[] {"Nothing to send","Нищо за изпращане. Всичко е изпратено"}},
            {"-110420" , new[] {"NRA server returns error","Сървъра на НАП връща грешка"}},
            {"-110481" , new[] {"Error in answer from NRA server on parameter 1","Грешка в отговора от сървъра на НАП при параметър 1"}},
            {"-110482" , new[] {"Error in answer from NRA server on parameter 2","Грешка в отговора от сървъра на НАП при параметър 2"}},
            {"-110483" , new[] {"Error in answer from NRA server on parameter 3","Грешка в отговора от сървъра на НАП при параметър 3"}},
            {"-110484" , new[] {"Error in answer from NRA server on parameter 4","Грешка в отговора от сървъра на НАП при параметър 4"}},
            {"-110485" , new[] {"Error in answer from NRA server on parameter 5","Грешка в отговора от сървъра на НАП при параметър 5"}},
            {"-110486" , new[] {"Error in answer from NRA server on parameter 6","Грешка в отговора от сървъра на НАП при параметър 6"}},
            {"-110487" , new[] {"Error in answer from NRA server on parameter 7","Грешка в отговора от сървъра на НАП при параметър 7"}},
            {"-110488" , new[] {"Error in answer from NRA server on parameter 8","Грешка в отговора от сървъра на НАП при параметър 8"}},
            {"-110489" , new[] {"Error in answer from NRA server on parameter 9","Грешка в отговора от сървъра на НАП при параметър 9"}},
            {"-110490" , new[] {"Error in answer from NRA server on parameter 10","Грешка в отговора от сървъра на НАП при параметър 10"}},
            {"-110491" , new[] {"Error in answer from NRA server on parameter 11","Грешка в отговора от сървъра на НАП при параметър 11"}},
            {"-110492" , new[] {"Error in answer from NRA server on parameter 12","Грешка в отговора от сървъра на НАП при параметър 12"}},
            {"-110493" , new[] {"Error in answer from NRA server on parameter 13","Грешка в отговора от сървъра на НАП при параметър 13"}},
            {"-110494" , new[] {"Error in answer from NRA server on parameter 14","Грешка в отговора от сървъра на НАП при параметър 14"}},
            {"-110495" , new[] {"Error in answer from NRA server on parameter 15","Грешка в отговора от сървъра на НАП при параметър 15"}},
            {"-110496" , new[] {"Error in answer from NRA server on parameter 16","Грешка в отговора от сървъра на НАП при параметър 16"}},

            {"-110500" , new[] {"Modem error: error in communication between device and modem","Грешка при работа с модема: грешка в комуникацията между устройството и модема"}},
            {"-110501" , new[] {"Modem error: No SIM card","Грешка при работа с модема: Няма СИМ карта"}},
            {"-110502" , new[] {"Modem error: Wrong PIN of SIM","Грешка при работа с модема: Грешен PIN на SIM"}},
            {"-110503" , new[] {"Modem error: Cannot register to mobile network","Грешка при работа с модема: Не се регистрира в мрежата"}},
            {"-110504" , new[] {"Modem error: No PPP connection( cannot connect )","Грешка при работа с модема: Няма PPP връзка( не може да се свръже )"}},
            {"-110505" , new[] {"Modem error: Wrong modem configuration( for example - no programmed apn )","Грешка при работа с модема: Грешна конфигурация на модема( например няма програмиран apn )"}},
            {"-110506" , new[] {"Modem error: Modem initializing","Грешка при работа с модема: Модема се инициализира"}},
            {"-110507" , new[] {"Modem error: Modem is not ready","Грешка при работа с модема: Модема не е готов за използване"}},
            {"-110508" , new[] {"Modem error: Remove SIM card","Грешка при работа с модема: Премахнете СИМ картата"}},
            {"-110509" , new[] {"Modem error: Modem found a cell","Грешка при работа с модема: Намерена е клетка"}},
            {"-110510" , new[] {"Modem error: Modem does not find a cell","Грешка при работа с модема: Не е намерена клетка"}},
            {"-110511" , new[] {"Modem error: Failed lot days","Грешка при работа с модема: Грешка от няколко дни"}},
            {"-110512" , new[] {"Modem error: Already connected to a different APN when a PPP connection is started","Грешка при работа с модема: Вече е свързан към различен APN когато се стартира PPP връзка"}},

            {"-110601" , new[] {"Modem error: Device is not connected to AP( access point )","Грешка в модема: Устройството не е свързано към AP( access point )"}},

            {"-110700" , new[] {"Network error: Cannot resolve address","Интернет грешка: Не може да се намери адреса"}},
            {"-110701" , new[] {"Network error: Cannot open socket for communication with server","Интернет грешка: Не може да отвори сокет за връзка със сървъра"}},
            {"-110702" , new[] {"Network error: Connection error( cannot connect to a server )","Интернет грешка: Грешка във връзката( не може да се свърже със сървър )"}},
            {"-110703" , new[] {"Network error: Config error( for example: no server address )","Интернет грешка: Грешка в конфигурацията за връзка със сървъра( например: няма зададен адрес на сървър )"}},
            {"-110704" , new[] {"Network error: Connection socket is already opened","Интернет грешка: Сокета вече е отворен"}},
            {"-110705" , new[] {"Network error: SSL communication error( something went wrong in cryptographic protocol )","Интернет грешка: Грешка в SSL комуникацията( грешка в криптирането от SSL )"}},
            {"-110706" , new[] {"Network error: HTTP communication error( something went wrong in http protocol )","Интернет грешка: Грешка в HTTP комуникацията"}},

            {"-110800" , new[] {"Tax terminal error: No error","Грешка от данъчния терминал: Няма грешка"}},
            {"-110801" , new[] {"Tax terminal error: Unknown ID","Грешка от данъчния терминал: Непознато ID"}},
            {"-110802" , new[] {"Tax terminal error: Invalid token( key from the server )","Грешка от данъчния терминал: Невалиден токен( ключ от сървъра )"}},
            {"-110803" , new[] {"Tax terminal error: Protocol error","Грешка от данъчния терминал: Грешка в протоокола"}},
            {"-110804" , new[] {"Tax terminal error: The command is unknown","Грешка от данъчния терминал: Неизвестна команда"}},
            {"-110805" , new[] {"Tax terminal error: The command is not supported","Грешка от данъчния терминал: Командата не се поддържа"}},
            {"-110806" , new[] {"Tax terminal error: Invalid configuration","Грешка от данъчния терминал: Невалидна конфигурация на устройството"}},
            {"-110807" , new[] {"Tax terminal error: SSL is not allowed","Грешка от данъчния терминал: Използването на SSL не е позволено"}},
            {"-110808" , new[] {"Tax terminal error: Invalid request number","Грешка от данъчния терминал: Невалиден номер на заявката"}},
            {"-110809" , new[] {"Tax terminal error: Invalid retry request","Грешка от данъчния терминал: Неправилна повторна заявка"}},
            {"-110810" , new[] {"Tax terminal error: Cannot cancel ticket","Грешка от данъчния терминал: Не може да се канселира"}},
            {"-110811" , new[] {"Tax terminal error: More than 24 hours from shift opening","Грешка от данъчния терминал: Повече от 24 часа от началото на смяната"}},
            {"-110812" , new[] {"Tax terminal error: Invalid login name or password","Грешка от данъчния терминал: Неправилно име или парола"}},
            {"-110813" , new[] {"Tax terminal error: Incorrect request data","Грешка от данъчния терминал: Неправилни входни данни"}},
            {"-110814" , new[] {"Tax terminal error: Not enough cash","Грешка от данъчния терминал: Няма достатъчно пари в брой"}},
            {"-110815" , new[] {"Tax terminal error: Blocked from server","Грешка от данъчния терминал: Блокирано от сървъра"}},
            {"-110854" , new[] {"Tax terminal error: Service temporarily unavailable","Грешка от данъчния терминал: Временно няма достъп до услугата"}},
            {"-110855" , new[] {"Tax terminal error: Unknown error","Грешка от данъчния терминал: Неизвестна грешка"}},

            {"-110900" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: No error","Грешка от фискален накопител( Русия ):  Няма грешка"}},
            {"-110901" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: Unknown command, wrong format or wrong parameters","Грешка от фискален накопител( Русия ): Неизвстна команда, невалиден формат или грешни параметри"}},
            {"-110902" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: Wrong state FN","Грешка от фискален накопител( Русия ): Грешно състояние на ФН"}},
            {"-110903" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: FN error","Грешка от фискален накопител( Русия ): ФН грешка"}},
            {"-110904" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: CC error( cryptographic co-processor )","Грешка от фискален накопител( Русия ): КК грешка ( криптографски копроцесор )"}},
            {"-110905" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: FN exploatation date expires","Грешка от фискален накопител( Русия ): Срока на експлоатация на FN модула изтича"}},
            {"-110906" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: FN archive is full","Грешка от фискален накопител( Русия ): ФН архива е препълнен"}},
            {"-110907" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: Invalid date or time","Грешка от фискален накопител( Русия ): Неверни дата или час"}},
            {"-110908" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: No data","Грешка от фискален накопител( Русия ): Няма данни"}},
            {"-110909" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: Wrong command parameters","Грешка от фискален накопител( Русия ): Грешни параметри на команда"}},
            {"-110916" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: TLV data over limit","Грешка от фискален накопител( Русия ): Превишаване на размера на TLV данните"}},
            {"-110917" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: No connection","Грешка от фискален накопител( Русия ): Няма връзка"}},
            {"-110918" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: Full resource ( cryptographic coprocessor )","Грешка от фискален накопител( Русия ): Изчерпан ресурс ( кроптографски копроцесор )"}},
            {"-110919" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: Full resource","Грешка от фискален накопител( Русия ): Изчерпан ресурс"}},
            {"-110920" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: Full resource for documents for OFD","Грешка от фискален накопител( Русия ): Изчерпан ресурс за документи към ОФД"}},
            {"-110921" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: Full resource for waiting transmitting data","Грешка от фискален накопител( Русия ): Изчерпан ресурс за чакане за предаване на информация"}},
            {"-110922" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: Shift duration more than 24 hours","Грешка от фискален накопител( Русия ): Продължителност на смяна повече от 24 часа"}},
            {"-110923" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: Wrong time difference between two operations","Грешка от фискален накопител( Русия ): Грешна разлика във времената между две операции"}},
            {"-110932" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: Data from OFD cannot be received","Грешка от фискален накопител( Русия ): Данните от ОФД не могат да бъдат приети"}},
            {"-110960" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: Unknown error","Грешка от фискален накопител( Русия ): Неизвестна грешка"}},
            {"-110961" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: Wrong state FN","Грешка от фискален накопител( Русия ): Грешно състояние на ФН"}},
            {"-110962" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: Wrong number FN","Грешка от фискален накопител( Русия ): Грешен номер на ФН"}},
            {"-110971" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: Cannot send","Грешка от фискален накопител( Русия ): Не може да се изпрати"}},
            {"-110972" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: No response","Грешка от фискален накопител( Русия ): Няма отговор"}},
            {"-110973" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: Timeout","Грешка от фискален накопител( Русия ): Таймаут"}},
            {"-110974" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: Not enough","Грешка от фискален накопител( Русия ): Недостатъчно"}},
            {"-110975" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: Invalid length","Грешка от фискален накопител( Русия ): Невалидна дължина"}},
            {"-110976" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: Wrong CRC","Грешка от фискален накопител( Русия ): Грешно CRC"}},
            {"-110979" , new[] {"FISCAL NAKOPITEL( RUSSIA ) error: Unknown communication error","Грешка от фискален накопител( Русия ): Неизвестна комуникационна грешка"}},

            {"-111000" , new[] {"Registration mode error: Common error, followed by deliting all data for the command","Грешка в режим регистрация: Обща грешка със следващо изтриване на всички въведени данни за командата"}},
            {"-111001" , new[] {"Registration mode error: Common error, followed by partly deliting data for the command","Грешка в режим регистрация: Обща грешка със следващо частично нулиране на командния ред"}},
            {"-111002" , new[] {"Registration mode error: Syntax error. Check the parameters of the command","Грешка в режим регистрация: Синктатична грешка. Проверете параметрите на командата"}},
            {"-111003" , new[] {"Registration mode error: Cannot do operation","Грешка в режим регистрация: Невъзможност да се извърши операцията"}},
            {"-111004" , new[] {"Registration mode error: PLU code was not found","Грешка в режим регистрация: Не е намерен номенклатурния код"}},
            {"-111005" , new[] {"Registration mode error: Forbidden VAT","Грешка в режим регистрация: Забранена данъчна група"}},
            {"-111006" , new[] {"Registration mode error: Overflow in multiplication of quantity and price","Грешка в режим регистрация: Препълване в умножението между количество и цена"}},
            {"-111007" , new[] {"Registration mode error: PLU has no price","Грешка в режим регистрация: Артикула няма цена"}},
            {"-111008" , new[] {"Registration mode error: Group is not in range","Грешка в режим регистрация: Невалиден параметър група"}},
            {"-111009" , new[] {"Registration mode error: Department is not in range","Грешка в режим регистрация: Невалиден параметър департамент"}},
            {"-111010" , new[] {"Registration mode error: BAR code does not exist","Грешка в режим регистрация: Не е намерен баркода"}},
            {"-111011" , new[] {"Registration mode error: Overflow of the PLU turnover","Грешка в режим регистрация: Препълване по регистър оборот на артикул"}},
            {"-111012" , new[] {"Registration mode error: Overflow of the PLU quantity","Грешка в режим регистрация: Препълване по регистър количество на артикул"}},
            {"-111013" , new[] {"Registration mode error: ECR daily registers overflow","Грешка в режим регистрация: Препълване в касовите регистри"}},
            {"-111014" , new[] {"Registration mode error: Bill total register overflow","Грешка в режим регистрация: Препълване регистрите тотал на сметката"}},
            {"-111015" , new[] {"Registration mode error: Receipt is opened","Грешка в режим регистрация: Бона е отворен"}},
            {"-111016" , new[] {"Registration mode error: Receipt is closed","Грешка в режим регистрация: Бона е затворен"}},
            {"-111017" , new[] {"Registration mode error: No cash in ECR","Грешка в режим регистрация: Няма налични пари в касата"}},
            {"-111018" , new[] {"Registration mode error: Payment is initiated","Грешка в режим регистрация: Започнало е плащане"}},
            {"-111019" , new[] {"Registration mode error: Maximum number of sales in receipt","Грешка в режим регистрация: Максимален брой продажби в бона"}},
            {"-111020" , new[] {"Registration mode error: No transactions","Грешка в режим регистрация: Няма транзакции"}},
            {"-111021" , new[] {"Registration mode error: Possible negative turnover","Грешка в режим регистрация: Сумата по дан.група става отрицателна"}},
            {"-111022" , new[] {"Registration mode error: Foreign payment has change","Грешка в режим регистрация: Има ресто при плащане в алтернативна валута"}},
            {"-111023" , new[] {"Registration mode error: Transaction is not found in the receipt","Грешка в режим регистрация: Търсената транзакция не е намерена в буфера на бона"}},
            {"-111024" , new[] {"Registration mode error: End of 24 hour blocking","Грешка в режим регистрация: Край на 24 часовата блокировка в режим регистриране"}},
            {"-111025" , new[] {"Registration mode error: Invalid invoice range","Грешка в режим регистрация: Невалиден обхват на фактури"}},
            {"-111026" , new[] {"Registration mode error: Operation is cancelled by operator","Грешка в режим регистрация: Операцията е прекъсната от оператора"}},
            {"-111027" , new[] {"Registration mode error: Operation approved by POS","Грешка в режим регистрация: Операцията е потвърдена от POS-a"}},
            {"-111028" , new[] {"Registration mode error: Operation is not approved by POS","Грешка в режим регистрация: Операцията е отхвърлена от POS-a"}},
            {"-111029" , new[] {"Registration mode error: POS terminal communication error","Грешка в режим регистрация: Комуникационна грешка в ПОС терминала"}},
            {"-111030" , new[] {"Registration mode error: Multiplication of quantity and price is 0","Грешка в режим регистрация: Умножението на количество и цена е 0"}},
            {"-111031" , new[] {"Registration mode error: Value is too big","Грешка в режим регистрация: Въведено е голямо число"}},
            {"-111032" , new[] {"Registration mode error: Value is bad","Грешка в режим регистрация: Грешно въведено число"}},
            {"-111033" , new[] {"Registration mode error: Price is too big","Грешка в режим регистрация: Голяма цена"}},
            {"-111034" , new[] {"Registration mode error: Price is bad","Грешка в режим регистрация: Грешна цена"}},
            {"-111035" , new[] {"Registration mode error: Operation all void is selected to be executed","Грешка в режим регистрация: Операция войд на бона да се стартира"}},
            {"-111036" , new[] {"Registration mode error: Only all void operation is permitted","Грешка в режим регистрация: Само операция All void е разрешена. За случаите когато в бона е направено скрито сторно!"}},
            {"-111040" , new[] {"Registration mode error: Restaurant: There is no free space for other purchases","Грешка в режим регистрация: ресторант: Няма свободно място в буфера за поръчките"}},
            {"-111041" , new[] {"Registration mode error: Restaurant: There is no free space for new acount","Грешка в режим регистрация: ресторант: Няма свободно за нови сметки"}},
            {"-111042" , new[] {"Registration mode error: Restaurant: Account is already opened","Грешка в режим регистрация: ресторант: Сметката е вече отворена"}},
            {"-111043" , new[] {"Registration mode error: Restaurant: Wrong index","Грешка в режим регистрация: ресторант: Грешка в индексирането на сметките"}},
            {"-111044" , new[] {"Registration mode error: Restaurant: Account is not found","Грешка в режим регистрация: ресторант: Сметката не е намерена"}},
            {"-111045" , new[] {"Registration mode error: Restaurant: Not permitted( only for admins )","Грешка в режим регистрация: ресторант: Не е разрешено ( само за администратори )"}},
            {"-111046" , new[] {"Registration mode error: non-fiscal receipt is open","Грешка в режим регистрация: Отворен е нефискален бон"}},
            {"-111047" , new[] {"Registration mode error: fiscal receipt is open","Грешка в режим регистрация: Отворен е фискален бон"}},
            {"-111048" , new[] {"Registration mode error: Buyers TIN is already entered","Грешка в режим регистрация: TIN на купувача е въведен"}},
            {"-111049" , new[] {"Registration mode error: Buyers TIN is not entered","Грешка в режим регистрация: TIN на купувача не е въведен"}},
            {"-111050" , new[] {"Registration mode error: Payment is not initiated","Грешка в режим регистрация: Плащането не е започнало"}},
            {"-111051" , new[] {"Registration mode error: Reeipt type mismatch","Грешка в режим регистрация: смесване на типове документи"}},
            {"-111052" , new[] {"Registration mode error: Receipt total limit is reached","Грешка в режим регистрация: достигнат лимит на TOTAL за бона"}},
            {"-111053" , new[] {"Registration mode error: Sum cannot be divided by the minimum coin","Грешка в режим регистрация: Сумата не е кратна на най-малката монета"}},
            {"-111054" , new[] {"Registration mode error: Sum must be <= payment amount","Грешка в режим регистрация: Сумата трябва да е <= на остатъка за плащане"}},
            {"-111055" , new[] {"Registration mode error: Sum of voucher must be entered when paying with voucher","Грешка в режим регистрация: При плащане с ваучери е задължително да се въведе сумата на ваучера"}},
            {"-111056" , new[] {"Registration mode error: Value surcharge of the difference between voucher sum and total must be done when paying with voucher and sum > total","Грешка в режим регистрация: При плащане с ваучери и сума > от ТЛ трябва да се направи стойностна надбавка за разликата"}},
            {"-111057" , new[] {"Registration mode error: Payment with foreign currency is disabled","Грешка в режим регистрация: Забранено плащане в алтернативна валута"}},
            {"-111058" , new[] {"Registration mode error: Payment with foreign currency is impossible","Грешка в режим регистрация: Невъзможно плащане в алтернативна валута"}},
            {"-111059" , new[] {"Registration mode error: Sum must be bigger or equal to payment amount","Грешка в режим регистрация: Сумата трябва да е по- голяма или равна на остатъка за плащане"}},
            {"-111060" , new[] {"Registration mode error: Safe opening is disabled","Грешка в режим регистрация: Забрана за отваряне на сейфа"}},
            {"-111061" , new[] {"Registration mode error: Forbidden payment","Грешка в режим регистрация: Забранено плащане"}},
            {"-111062" , new[] {"Registration mode error: Forbidden key for surcharge/discount","Грешка в режим регистрация: Забранен клавиш за отстъпка/надбавка"}},
            {"-111063" , new[] {"Registration mode error: Entered sum is bigger than receipt sum","Грешка в режим регистрация: Въведена е сума по-голяма от сумата на чека"}},
            {"-111064" , new[] {"Registration mode error: Entered sum is smaller than receipt sum","Грешка в режим регистрация: Въведена е сума по-малка от сумата на чека"}},
            {"-111065" , new[] {"Registration mode error: Fiscal printer: Sum of receipt is 0. Operation 'void' is needed","Грешка в режим регистрация: За ф.принтер: Сумата на чека е 0. Необходима е операция 'анулиране на бона'."}},
            {"-111066" , new[] {"Registration mode error: Fiscal printer: Operation 'void' is executed. Close receipt is needed","Грешка в режим регистрация: За ф.принтер: Изпълнена е операция 'анулиране на бона'. Необходимо е затваряне на бона."}},
            {"-111067" , new[] {"Registration mode error: Storno receipt is opened","Грешка в режим регистрация: Отворен е сторно бон"}},
            {"-111068" , new[] {"Registration mode error: Sum is not entered","Грешка в режим регистрация: Не е въведена сума"}},
            {"-111069" , new[] {"Registration mode error: Price type is invalid","Грешка в режим регистрация: Невалиден параметър тип на цената"}},
            {"-111070" , new[] {"Registration mode error: Linked surcharge is forbidden","Грешка в режим регистрация: Забранен тип 'свързана надбавка'"}},
            {"-111071" , new[] {"Registration mode error: Negative price is forbidden","Грешка в режим регистрация: Забранен тип 'отрицателна цена'"}},
            {"-111072" , new[] {"Registration mode error: More than 1 VAT in one receipt is not allowed","Грешка в режим регистрация: Не се допуска повече от една данъчна група в един чек"}},
            {"-111073" , new[] {"Registration mode error: Pinpad error","Грешка в режим регистрация: Пинпад грешка"}},
            {"-111074" , new[] {"Registration mode error: Buyer data is wrong","Грешка в режим регистрация: Данните за купувача не съвпадат"}},
            {"-111075" , new[] {"Registration mode error: Vat system disable.","Грешка в режим регистрация: Системата за данъчно облагане е забранена."}},
            {"-111076" , new[] {"Operator not logged in.","Грешка в режим регистрация: Няма логнат оператор."}},
            {"-111077" , new[] {"The receipt date is early on last date in fiscal memory.","Датата на текущия бон е по-малка от последната във ФП."}},
            {"-111078" , new[] {"Correction receipt data is not entered!","Не са въведени данни за бон корекция!"}},
            {"-111079" , new[] {"Fractional quantity!","Дробно количество!"}},
            {"-111080" , new[] {"Registration mode error: Registration mode error: Out of stock","Грешка в режим регистрация: Няма налично количество"}},
            {"-111081" , new[] {"Registration mode error: Must pushing of the STL before TL.","Грешка в режим регистрация: Необходимо е натискане на STL преди TL."}},
            {"-111082" , new[] {"Package does not exist","Не е намерена опаковка"}},
            {"-111083" , new[] {"Measuring unit not found","Мярната единица не е намерена"}},
            {"-111084" , new[] {"Category not found in the data base","Категорията не е намерена в базата с категории"}},
            {"-111085" , new[] {"Invalid department name","Невалидно име на департамент"}},
            {"-111086" , new[] {"Bank terminal not configured","Не е конфигуриран банков терминал"}},
            {"-111087" , new[] {"Disallowed 'ןנטחםאך נאסקועא' (Russia)","Непозволен 'признак расчета' (Русия)."}},
            {"-111088" , new[] {"Forbidden ןנטחםאך עמגאנא","Непозволен признак товара"}},
            {"-111089" , new[] {"Entered price is bigger than the programmed","Въведената цена е по-голяма от програмираната"}},
            {"-111090" , new[] {"Fix PLU's price","Типа на цената не позволява свободна цена"}},
            {"-111091" , new[] {"Incorect sign agent.","Недокустим признак за агент."}},
            {"-111092" , new[] {"Voucher payment cannot have change","Плащане с ваучер не може да има ресто"}},
            {"-111093" , new[] {"Sum for advance payment is bigger than the sum of article","Сумата за капаро е по-голяма от сумата на артикула"}},
            {"-111094" , new[] {"Payment in storno can not have change","Плащане в сторно не може да има ресто"}},
            {"-111095" , new[] {"Invalid parameter - PLU is not defined as excise PLU","Невалиден параметър - товарът не е дефиниран като акцизен"}},
            {"-111096" , new[] {"Excise stamp of an excise PLU is not entered","Не е въведена акцизната марка на акцизен товар"}},
            {"-111097" , new[] {"SALE FORBIDDEN (excise stamp is not valid)","Забранена продажба на акцизен товар (невалидна или непотвърдена акц.марка)"}},

            {"-111500" , new[] {"Pinpad error: No error from pinpad","Грешка при работа с пинпад: Няма грешка от пинпада"}},
            {"-111501" , new[] {"Pinpad error: General unicreditbulbank icon error","Грешка при работа с пинпад: Грешка от уникредит булбанк"}},
            {"-111502" , new[] {"Pinpad error: Not valid command or sub command code","Грешка при работа с пинпад: Невалидна команда или подкоманда"}},
            {"-111503" , new[] {"Pinpad error: Invalid parameter","Грешка при работа с пинпад: Невалиден параметър"}},
            {"-111504" , new[] {"Pinpad error: The address is outside limits","Грешка при работа с пинпад: Невалиден адрес"}},
            {"-111505" , new[] {"Pinpad error: The value is outside limits","Грешка при работа с пинпад: Невалидна стойност"}},
            {"-111506" , new[] {"Pinpad error: The length is outside limits","Грешка при работа с пинпад: Невалидна дължина"}},
            {"-111507" , new[] {"Pinpad error: The action is not permited in current state","Грешка при работа с пинпад: Действието не е позволено в текущото състояние"}},
            {"-111508" , new[] {"Pinpad error: There is no data to be returned","Грешка при работа с пинпад: Няма данни за връщане"}},
            {"-111509" , new[] {"Pinpad error: Timeout occurs","Грешка при работа с пинпад: Таймаут"}},
            {"-111510" , new[] {"Pinpad error: Invalid key number","Грешка при работа с пинпад: Невалиден код"}},
            {"-111511" , new[] {"Pinpad error: Invalid key attributes(usage)","Грешка при работа с пинпад: Невалидни параметри на ключ"}},
            {"-111512" , new[] {"Pinpad error: Calling of non-existing device","Грешка при работа с пинпад: Заявка от несъществуващо устройство"}},
            {"-111513" , new[] {"Pinpad error: (Not used in this FW version)","Грешка при работа с пинпад: ( Не се поддържа в тази версия на фърмуера )"}},
            {"-111514" , new[] {"Pinpad error: Pin entering limit exceed","Грешка при работа с пинпад: Лимит на въвеждането на ПИН"}},
            {"-111515" , new[] {"Pinpad error: General error in flash commands","Грешка при работа с пинпад: Грешка във флаша"}},
            {"-111516" , new[] {"Pinpad error: General hardware unicreditbulbank error","Грешка при работа с пинпад: Хардуерна грешка"}},
            {"-111517" , new[] {"Pinpad error: Invalid code check (Not used in this FW version)","Грешка при работа с пинпад: Невалидна проверка на кода ( Не се поддържа в тази версия на фърмуера )"}},
            {"-111518" , new[] {"Pinpad error: The button 'CANCEL' is pressed","Грешка при работа с пинпад: Натиснат е бутонът 'CANCEL'"}},
            {"-111519" , new[] {"Pinpad error: Invalid signature","Грешка при работа с пинпад: Невалиден подпис"}},
            {"-111520" , new[] {"Pinpad error: Invalid data in header","Грешка при работа с пинпад: Невалидни данни в хедъра"}},
            {"-111521" , new[] {"Pinpad error: Incorrect password","Грешка при работа с пинпад: Грешна парола"}},
            {"-111522" , new[] {"Pinpad error: Invalid key format","Грешка при работа с пинпад: Невалиден формат на ключ"}},
            {"-111523" , new[] {"Pinpad error: General unicreditbulbank error in smart card reader","Грешка при работа с пинпад: Грешка в четеца на смарт карти"}},
            {"-111524" , new[] {"Pinpad error: Error code returned from HAL functions","Грешка при работа с пинпад: Грешка върната от HAL функция"}},
            {"-111525" , new[] {"Pinpad error: Invalid key (may not be present)","Грешка при работа с пинпад: Невалиден ключ"}},
            {"-111526" , new[] {"Pinpad error: The PIN length is less than 4 or bigger than 12","Грешка при работа с пинпад: Дължината на пина е <4 или >12"}},
            {"-111527" , new[] {"Pinpad error: Issuer or ICC key invalid remainder length","Грешка при работа с пинпад: Невалидна дължина на ICC ключ"}},
            {"-111528" , new[] {"Pinpad error: Not initialized (Not used in this FW version)","Грешка при работа с пинпад: Не е инициализирано ( Не се поддържа в тази версия на фърмуера )"}},
            {"-111529" , new[] {"Pinpad error: Limit is reached (Not used in this FW version)","Грешка при работа с пинпад: Достигнат лимит ( Не се поддържа в тази версия на фърмуера )"}},
            {"-111530" , new[] {"Pinpad error: Invalid sequence (Not used in this FW version)","Грешка при работа с пинпад: Грешна последователност ( Не се поддържа в тази версия на фърмуера )"}},
            {"-111531" , new[] {"Pinpad error: The action is not permitted","Грешка при работа с пинпад: Операцията не е позволена"}},
            {"-111532" , new[] {"Pinpad error: TMK is not loaded. The action cannot be executed","Грешка при работа с пинпад: TMK не е зареден. Операцията не може да бъде изпълнена"}},
            {"-111533" , new[] {"Pinpad error: Wrong key format","Грешка при работа с пинпад: Грешен формат"}},
            {"-111534" , new[] {"Pinpad error: Duplicated key","Грешка при работа с пинпад: Дублиран ключ"}},
            {"-111535" , new[] {"Pinpad error: General keyboard error","Грешка при работа с пинпад: Грешка в клавиатурата"}},
            {"-111536" , new[] {"Pinpad error: The keyboard is no calibrated.","Грешка при работа с пинпад: Клавиатурата не е калибрирана"}},
            {"-111537" , new[] {"Pinpad error: Keyboard bug detected.","Грешка при работа с пинпад: Бъг в клавиатурата"}},
            {"-111538" , new[] {"Pinpad error: The device is busy, try again","Грешка при работа с пинпад: Устройството е заето, опитайте отново"}},
            {"-111539" , new[] {"Pinpad error: Device is tampered","Грешка при работа с пинпад: Устройството е компрометирано"}},
            {"-111540" , new[] {"Pinpad error: Error in encrypted head","Грешка при работа с пинпад: Грешка в криптиращата глава"}},
            {"-111541" , new[] {"Pinpad error: The button 'OK' is pressed","Грешка при работа с пинпад: Бутонът 'OK' е натиснат"}},
            {"-111542" , new[] {"Pinpad error: Wrong PAN","Грешка при работа с пинпад: Грешен PAN"}},
            {"-111543" , new[] {"Pinpad error: Out of memory","Грешка при работа с пинпад: Няма памет"}},
            {"-111544" , new[] {"Pinpad error: EMV error","Грешка при работа с пинпад: EMV грешка"}},
            {"-111545" , new[] {"Pinpad error: Cryptographic error","Грешка при работа с пинпад: Криптографска грешка"}},
            {"-111546" , new[] {"Pinpad error: Communication error","Грешка при работа с пинпад: Комуникационна грешка"}},
            {"-111547" , new[] {"Pinpad error: Invalid firmware version","Грешка при работа с пинпад: Невалидна версия на фърмуера"}},
            {"-111548" , new[] {"Pinpad error: Printer is out of paper","Грешка при работа с пинпад: Няма хартия в принтера"}},
            {"-111549" , new[] {"Pinpad error: Printer is overheated","Грешка при работа с пинпад: Принтера прегрява"}},
            {"-111550" , new[] {"Pinpad error: Device is not connected","Грешка при работа с пинпад: Устройството не е свързано"}},
            {"-111551" , new[] {"Pinpad error: Use the chip reader","Грешка при работа с пинпад: Използвайте четеца за чипове"}},
            {"-111552" , new[] {"Pinpad error: End the day first","Грешка при работа с пинпад: Приключете ден първо"}},
            {"-111554" , new[] {"Pinpad error: Error from Borica","Грешка при работа с пинпад: Грешка от Борика"}},
            {"-111555" , new[] {"Pinpad error: No connection with pinpad","Грешка при работа с пинпад: Няма връзка с пинпада"}},
            {"-111556" , new[] {"Pinpad error: Success in pinpad, unsuccess in ECR","Грешка при работа с пинпад: Успешно в пинпада, неуспешно в касата"}},
            {"-111557" , new[] {"Pinpad error: Not configured connection between fiscal device and PinPad","Грешка при работа с пинпад: Не е конфигурирана връзка за работа с пинпад"}},
            {"-111558" , new[] {"Pinpad error: The last transactions are equals or connection is interrupted - try again.","Грешка при работа с пинпад: Последните транзакции в пинпада и в касата са еднакви или е била прекъсната връзката с пинпада. Опитайте отново."}},
            {"-111559" , new[] {"Pinpad error: Payment type: debit/credit card via PinPad. In the fiscal receipt is allowed only one payment with such type.","Грешка при работа с пинпад: Не може да има 2 плащания с карта с пинпад в 1 бон."}},
            {"-111560" , new[] {"Pinpad error: Unknown result of the transaction between fiscal device and PinPad","Грешка при работа с пинпад: Грешка за неизвестен резултат от транзакция между фискалното устройство и PinPad"}},
            {"-111561" , new[] {"Pinpad error: Pinpad type not configured","Грешка при работа с пинпад: Не е конфигуриран тип на пинпада"}},
            {"-111700" , new[] {"Pinpad error: Invalid ammount.","Грешка при работа с пинпад: Невалидна сума."}},
            {"-111701" , new[] {"Pinpad error: Transaction not found.","Грешка при работа с пинпад: Транзакцията не е открита."}},
            {"-111702" , new[] {"Pinpad error: The file is empty.","Грешка при работа с пинпад: Файлът е празен"}},
            {"-111703" , new[] {"Entered cashback is bigger than cashback limit.","Въведеният кешбек е по-голям от лимита за кешбек."}},

            {"-111800" , new[] {"ERR_SCALE_NOT_RESPOND","ERR_SCALE_NOT_RESPOND"}},
            {"-111801" , new[] {"ERR_SCALE_NOT_CALCULATED","ERR_SCALE_NOT_CALCULATED"}},
            {"-111802" , new[] {"ERR_SCALE_WRONG_RESPONSE","ERR_SCALE_WRONG_RESPONSE"}},
            {"-111803" , new[] {"ERR_SCALE_ZERO_WEIGHT","ERR_SCALE_ZERO_WEIGHT"}},
            {"-111804" , new[] {"ERR_SCALE_NEGATIVE_WEIGHT","ERR_SCALE_NEGATIVE_WEIGHT"}},
            {"-111805" , new[] {"ERR_SCALE_T_WRONG_INTF","ERR_SCALE_T_WRONG_INTF"}},
            {"-111806" , new[] {"ERR_SCALE_T_CONNECT","ERR_SCALE_T_CONNECT"}},
            {"-111807" , new[] {"ERR_SCALE_SEND","ERR_SCALE_SEND"}},
            {"-111808" , new[] {"ERR_SCALE_RECEIVE","ERR_SCALE_RECEIVE"}},
            {"-111809" , new[] {"ERR_SCALE_FILE_GENERATE","ERR_SCALE_FILE_GENERATE"}},
            {"-111810" , new[] {"ERR_SCALE_NOT_CONFIG","ERR_SCALE_NOT_CONFIG"}},

            {"-111900" , new[] {"Communication error wtih NTP server: Cannot make communication","Грешка при комуникация с NTP сървър: Не може да се осъществи комуникация"}},
            {"-111901" , new[] {"Communication error wtih NTP server: The date and time is earlier than the last saved in the fiscal memory","Грешка при комуникация с NTP сървър: Датата и часа са по-ранни от последните записани във фискалната памет"}},
            {"-111902" , new[] {"Communication error wtih NTP server: Wrong IP address","Грешка при комуникация с NTP сървър: Не е въведен IP адрес"}},


            {"-112000" , new[] {"Fiscal printer error: Fiscal printer invalid command","Грешка от фискален принтер: Невалидна команда на фискалния принтер"}},
            {"-112001" , new[] {"Fiscal printer error: Fiscal printer command invalid syntax","Грешка от фискален принтер: Невалиден синтаксис на команда на фискалния принтер"}},
            {"-112002" , new[] {"Fiscal printer error: Command is not permitted","Грешка от фискален принтер: Команда не е позволена"}},
            {"-112003" , new[] {"Fiscal printer error: Register overflow","Грешка от фискален принтер: Препълване на регистър"}},
            {"-112004" , new[] {"Fiscal printer error: Wrong date/time","Грешка от фискален принтер: Невалидна дата и/или час"}},
            {"-112005" , new[] {"Fiscal printer error: PC mode is needed","Грешка от фискален принтер: Необходим е режим връзка с компютър"}},
            {"-112006" , new[] {"Fiscal printer error: No paper","Грешка от фискален принтер: Няма хартия"}},
            {"-112007" , new[] {"Fiscal printer error: Cover is open","Грешка от фискален принтер: Отворен капак"}},
            {"-112008" , new[] {"Fiscal printer error: Printing mechanism error","Грешка от фискален принтер: Грешка в печатащия механизъм"}},

            {"-112100" , new[] {"_ERR_FP_SYNTAX_PARAM_BEGIN","_ERR_FP_SYNTAX_PARAM_BEGIN"}},
            {"-112101" , new[] {"Invalid syntax of parameter 1.","Грешка в синтаксиса на параметър 1."}},
            {"-112102" , new[] {"Invalid syntax of parameter 2.","Грешка в синтаксиса на параметър 2."}},
            {"-112103" , new[] {"Invalid syntax of parameter 3.","Грешка в синтаксиса на параметър 3."}},
            {"-112104" , new[] {"Invalid syntax of parameter 4.","Грешка в синтаксиса на параметър 4."}},
            {"-112105" , new[] {"Invalid syntax of parameter 5.","Грешка в синтаксиса на параметър 5."}},
            {"-112106" , new[] {"Invalid syntax of parameter 6.","Грешка в синтаксиса на параметър 6."}},
            {"-112107" , new[] {"Invalid syntax of parameter 7.","Грешка в синтаксиса на параметър 7."}},
            {"-112108" , new[] {"Invalid syntax of parameter 8.","Грешка в синтаксиса на параметър 8."}},
            {"-112109" , new[] {"Invalid syntax of parameter 9.","Грешка в синтаксиса на параметър 9."}},
            {"-112110" , new[] {"Invalid syntax of parameter 10.","Грешка в синтаксиса на параметър 10."}},
            {"-112111" , new[] {"Invalid syntax of parameter 11.","Грешка в синтаксиса на параметър 11."}},
            {"-112112" , new[] {"Invalid syntax of parameter 12.","Грешка в синтаксиса на параметър 12."}},
            {"-112113" , new[] {"Invalid syntax of parameter 13.","Грешка в синтаксиса на параметър 13."}},
            {"-112114" , new[] {"Invalid syntax of parameter 14.","Грешка в синтаксиса на параметър 14."}},
            {"-112115" , new[] {"Invalid syntax of parameter 15.","Грешка в синтаксиса на параметър 15."}},
            {"-112116" , new[] {"Invalid syntax of parameter 16.","Грешка в синтаксиса на параметър 16."}},
            {"-112199" , new[] {"_ERR_FP_SYNTAX_PARAM_END","_ERR_FP_SYNTAX_PARAM_END"}},

            {"-112200" , new[] {"_ERR_FP_BAD_PARAM_BEGIN","_ERR_FP_BAD_PARAM_BEGIN"}},
            {"-112201" , new[] {"Bad value of parameter 1.","Грешна стойност на параметър 1."}},
            {"-112202" , new[] {"Bad value of parameter 2.","Грешна стойност на параметър 2."}},
            {"-112203" , new[] {"Bad value of parameter 3.","Грешна стойност на параметър 3."}},
            {"-112204" , new[] {"Bad value of parameter 4.","Грешна стойност на параметър 4."}},
            {"-112205" , new[] {"Bad value of parameter 5.","Грешна стойност на параметър 5."}},
            {"-112206" , new[] {"Bad value of parameter 6.","Грешна стойност на параметър 6."}},
            {"-112207" , new[] {"Bad value of parameter 7.","Грешна стойност на параметър 7."}},
            {"-112208" , new[] {"Bad value of parameter 8.","Грешна стойност на параметър 8."}},
            {"-112209" , new[] {"Bad value of parameter 9.","Грешна стойност на параметър 9."}},
            {"-112210" , new[] {"Bad value of parameter 10.","Грешна стойност на параметър 10."}},
            {"-112211" , new[] {"Bad value of parameter 11.","Грешна стойност на параметър 11."}},
            {"-112212" , new[] {"Bad value of parameter 12.","Грешна стойност на параметър 12."}},
            {"-112213" , new[] {"Bad value of parameter 13.","Грешна стойност на параметър 13."}},
            {"-112214" , new[] {"Bad value of parameter 14.","Грешна стойност на параметър 14."}},
            {"-112215" , new[] {"Bad value of parameter 15.","Грешна стойност на параметър 15."}},
            {"-112216" , new[] {"Bad value of parameter 16.","Грешна стойност на параметър 16."}},
            {"-112299" , new[] {"_ERR_FP_BAD_PARAM_END","_ERR_FP_BAD_PARAM_END"}},

            {"-112900" , new[] {"_ERR_RANGE_EM_BEGIN","_ERR_RANGE_EM_BEGIN"}},
            {"-112999" , new[] {"_ERR_RANGE_EM_END","_ERR_RANGE_EM_END"}},

            {"-113000" , new[] {"Flash memory error: Reading ID error","Грешка във флаш паметта: Грешка при четене на ID"}},
            {"-113001" , new[] {"Flash memory error: Sector size error","Грешка във флаш паметта: Грешка в размера на секторите"}},

            {"-114000" , new[] {"POS- terminal error: Communication channel is closed","Грешка от ПОС- терминал: Канала за връзка е затворен."}},

            {"-114998" , new[] {"Crypto module error: Wrong ID numbers","Грешка от крипто модула: Грешни ID номера"}},
            {"-114999" , new[] {"Crypto module וננמנ: Unexpected response","Грешка от крипто модула: Неочакван отговор"}},
            {"-115000" , new[] {"Crypto module וננמנ: CM is disconnected","Грешка от крипто модула: Крипто модула не е свързан"}},
            {"-115001" , new[] {"Crypto module וננמנ: Communication error","Грешка от крипто модула: Грешка в комуникацията"}},
            {"-115002" , new[] {"Crypto module וננמנ: Timeout","Грешка от крипто модула: Таймаут"}},
            {"-116000" , new[] {"Crypto module וננמנ: Crypto module errors range begin.","Грешка от крипто модула: Начало на обхвата с грешки от криптомодула."}},
            {"-117999" , new[] {"Crypto module וננמנ: Crypto module errors range end.","Грешка от крипто модула: Край на обхвата с грешки от криптомодула."}},

            {"-118000" , new[] {"ECR server error: The connection socket is not open","Грешка от ECR сървъра: Сокетът не е отворен"}},
            {"-118001" , new[] {"ECR server error: The set for this command is not opened","Грешка от ECR сървъра: Няма отворен сет за тази команда"}},
            {"-118002" , new[] {"ECR server error: Wrong parameter","Грешка от ECR сървъра: Грешен параметър при обработка на онлайн"}},
            {"-118003" , new[] {"ECR server error: Socket send error. Could not send data to server","Грешка от ECR сървъра: Грешка при изпращане по сокета. Неуспешно изпращане към сървъра"}},
            {"-118004" , new[] {"ECR server error: Receiving timeout. No data is receivec on time","Грешка от ECR сървъра: Таймaут при приемане"}},
            {"-118005" , new[] {"ECR server error: Socket is closed","Грешка от ECR сървъра: Сокета е затворен"}},
            {"-118006" , new[] {"ECR server error: Unknown state","Грешка от ECR сървъра: Непознато състояние"}},
            {"-118007" , new[] {"ECR server error: Forbidden operation","Грешка от ECR сървъра: Забранена операция"}},

            {"-119000" , new[] {"PACK database error: PACK code already exists","Грешка в базата данни на опаковките: Опаковка с такъв код съществува"}},
            {"-119001" , new[] {"PACK database error: PACK database is full","Грешка в базата данни на опаковките: Базата с данни за опаковките е пълна"}},
            {"-119002" , new[] {"PACK database error: PACK has turnover","Грешка в базата данни на опаковките: Опаковката има оборт"}},
            {"-119003" , new[] {"PACK database error: In the PACK base has an article with same name.","Грешка в базата данни на опаковките: В базате има опаковка с такова име."}},
            {"-119004" , new[] {"PACK database error: PACK name is not unique.","Грешка в базата данни на опаковките: Името на опаковката не е уникално."}},
            {"-119005" , new[] {"Can't open the PACK database file","Не може да отвори файла с базата на опаковките"}},

            {"-120000" , new[] {"Programming: Name is not unique!","Програмиране: Името не е уникално!"}},
            {"-120001" , new[] {"Programming: Operator password is not unique!","Програмиране: Паролата на оператора не е уникална!"}},
            {"-120002" , new[] {"Programming: Date and time is under the range.","Програмиране: Датата и часът са под допустимите стойности"}},
            {"-120003" , new[] {"Programming: Date and time is under the range.","Програмиране: Датата и часът са над допустимите стойности."}},

            {"-121000" , new[] {"Barcode scanner reading error!","Грешка в скенера за баркод!"}},
            {"-121001" , new[] {"Invalid EIK/EGN number!","Невалиден ЕИК/ЕГН!"}},

            {"-170000" , new[] {"USB error: Host init error","USB грешка: Грешка при инициализация на хост"}},
            {"-170001" , new[] {"USB error: No device","USB грешка: Няма устройство"}},
            {"-170002" , new[] {"USB error: No filesystem","USB грешка: Няма файлова система"}},
            {"-170003" , new[] {"USB error: File open error","USB грешка: Грешка при отваряне на файл"}},
            {"-170004" , new[] {"USB error: File copy error","USB грешка: Грешка при копиране на файл"}},
            {"-170005" , new[] {"USB error: File unpack error","USB грешка: Грешка при ънпакване на файл"}},

            {"-171000" , new[] {"Rental database: Not found","База данни с наеми: Не е намерено"}},
            {"-171001" , new[] {"Rental database: Full","База данни с наеми: Всичко е заето"}},
            {"-171002" , new[] {"Rental database: Position is occupied","База данни с наеми: Позицията е заета"}},
            {"-171003" , new[] {"Rental database: Position is free","База данни с наеми: Позицията е свободна"}},
            {"-171004" , new[] {"Rental database: Subscription is active","База данни с наеми: Има активен абонамент"}}
        };
    
    }
    
}
