/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.shape;

import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.support.design.internal.Experimental;
import android.support.design.shape.CornerTreatment;
import android.support.design.shape.EdgeTreatment;
import android.support.design.shape.ShapePath;
import android.support.design.shape.ShapePathModel;
import android.support.v4.graphics.drawable.TintAwareDrawable;

@Experimental(value="The shapes API is currently experimental and subject to change")
public class MaterialShapeDrawable
extends Drawable
implements TintAwareDrawable {
    private final Paint paint = new Paint();
    private final Matrix[] cornerTransforms = new Matrix[4];
    private final Matrix[] edgeTransforms = new Matrix[4];
    private final ShapePath[] cornerPaths = new ShapePath[4];
    private final Matrix matrix = new Matrix();
    private final Path path = new Path();
    private final PointF pointF = new PointF();
    private final ShapePath shapePath = new ShapePath();
    private final Region transparentRegion = new Region();
    private final Region scratchRegion = new Region();
    private final float[] scratch = new float[2];
    private final float[] scratch2 = new float[2];
    @Nullable
    private ShapePathModel shapedViewModel = null;
    private boolean shadowEnabled = false;
    private boolean useTintColorForShadow = false;
    private float interpolation = 1.0f;
    private int shadowColor = -16777216;
    private int shadowElevation = 5;
    private int shadowRadius = 10;
    private int alpha = 255;
    private float scale = 1.0f;
    private float strokeWidth = 0.0f;
    private Paint.Style paintStyle = Paint.Style.FILL_AND_STROKE;
    @Nullable
    private PorterDuffColorFilter tintFilter;
    private PorterDuff.Mode tintMode = PorterDuff.Mode.SRC_IN;
    private ColorStateList tintList = null;

    public MaterialShapeDrawable() {
        this(null);
    }

    public MaterialShapeDrawable(@Nullable ShapePathModel shapePathModel) {
        this.shapedViewModel = shapePathModel;
        for (int i = 0; i < 4; ++i) {
            this.cornerTransforms[i] = new Matrix();
            this.edgeTransforms[i] = new Matrix();
            this.cornerPaths[i] = new ShapePath();
        }
    }

    private static int modulateAlpha(int paintAlpha, int alpha) {
        int scale = alpha + (alpha >>> 7);
        return paintAlpha * scale >>> 8;
    }

    @Nullable
    public ShapePathModel getShapedViewModel() {
        return this.shapedViewModel;
    }

    public void setShapedViewModel(ShapePathModel shapedViewModel) {
        this.shapedViewModel = shapedViewModel;
        this.invalidateSelf();
    }

    public ColorStateList getTintList() {
        return this.tintList;
    }

    public void setTintList(ColorStateList tintList) {
        this.tintList = tintList;
        this.updateTintFilter();
        this.invalidateSelf();
    }

    public void setTintMode(PorterDuff.Mode tintMode) {
        this.tintMode = tintMode;
        this.updateTintFilter();
        this.invalidateSelf();
    }

    public void setTint(@ColorInt int tintColor) {
        this.setTintList(ColorStateList.valueOf((int)tintColor));
    }

    public int getOpacity() {
        return -3;
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.alpha = alpha;
        this.invalidateSelf();
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public Region getTransparentRegion() {
        Rect bounds = this.getBounds();
        this.transparentRegion.set(bounds);
        this.getPath(bounds.width(), bounds.height(), this.path);
        this.scratchRegion.setPath(this.path, this.transparentRegion);
        this.transparentRegion.op(this.scratchRegion, Region.Op.DIFFERENCE);
        return this.transparentRegion;
    }

    public boolean isPointInTransparentRegion(int x, int y) {
        return this.getTransparentRegion().contains(x, y);
    }

    public boolean isShadowEnabled() {
        return this.shadowEnabled;
    }

    public void setShadowEnabled(boolean shadowEnabled) {
        this.shadowEnabled = shadowEnabled;
        this.invalidateSelf();
    }

    public float getInterpolation() {
        return this.interpolation;
    }

    public void setInterpolation(float interpolation) {
        this.interpolation = interpolation;
        this.invalidateSelf();
    }

    public int getShadowElevation() {
        return this.shadowElevation;
    }

    public void setShadowElevation(int shadowElevation) {
        this.shadowElevation = shadowElevation;
        this.invalidateSelf();
    }

    public int getShadowRadius() {
        return this.shadowRadius;
    }

    public void setShadowRadius(int shadowRadius) {
        this.shadowRadius = shadowRadius;
        this.invalidateSelf();
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.invalidateSelf();
    }

    public void setUseTintColorForShadow(boolean useTintColorForShadow) {
        this.useTintColorForShadow = useTintColorForShadow;
        this.invalidateSelf();
    }

    public void setShadowColor(int shadowColor) {
        this.shadowColor = shadowColor;
        this.useTintColorForShadow = false;
        this.invalidateSelf();
    }

    public Paint.Style getPaintStyle() {
        return this.paintStyle;
    }

    public void setPaintStyle(Paint.Style paintStyle) {
        this.paintStyle = paintStyle;
        this.invalidateSelf();
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        this.paint.setColorFilter((ColorFilter)this.tintFilter);
        int prevAlpha = this.paint.getAlpha();
        this.paint.setAlpha(MaterialShapeDrawable.modulateAlpha(prevAlpha, this.alpha));
        this.paint.setStrokeWidth(this.strokeWidth);
        this.paint.setStyle(this.paintStyle);
        if (this.shadowElevation > 0 && this.shadowEnabled) {
            this.paint.setShadowLayer((float)this.shadowRadius, 0.0f, (float)this.shadowElevation, this.shadowColor);
        }
        if (this.shapedViewModel != null) {
            this.getPath(canvas.getWidth(), canvas.getHeight(), this.path);
            canvas.drawPath(this.path, this.paint);
        } else {
            canvas.drawRect(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight(), this.paint);
        }
        this.paint.setAlpha(prevAlpha);
    }

    public void getPathForSize(int width, int height, Path path) {
        int index;
        path.rewind();
        if (this.shapedViewModel == null) {
            return;
        }
        for (index = 0; index < 4; ++index) {
            this.setCornerPathAndTransform(index, width, height);
            this.setEdgeTransform(index, width, height);
        }
        for (index = 0; index < 4; ++index) {
            this.appendCornerPath(index, path);
            this.appendEdgePath(index, path);
        }
        path.close();
    }

    private void setCornerPathAndTransform(int index, int width, int height) {
        this.getCoordinatesOfCorner(index, width, height, this.pointF);
        float angle = this.angleOfCorner(index, width, height);
        this.getCornerTreatmentForIndex(index).getCornerPath(angle, this.interpolation, this.cornerPaths[index]);
        float prevEdgeAngle = this.angleOfEdge((index - 1 + 4) % 4, width, height) + 1.5707964f;
        this.cornerTransforms[index].reset();
        this.cornerTransforms[index].setTranslate(this.pointF.x, this.pointF.y);
        this.cornerTransforms[index].preRotate((float)Math.toDegrees(prevEdgeAngle));
    }

    private void setEdgeTransform(int index, int width, int height) {
        this.scratch[0] = this.cornerPaths[index].endX;
        this.scratch[1] = this.cornerPaths[index].endY;
        this.cornerTransforms[index].mapPoints(this.scratch);
        float edgeAngle = this.angleOfEdge(index, width, height);
        this.edgeTransforms[index].reset();
        this.edgeTransforms[index].setTranslate(this.scratch[0], this.scratch[1]);
        this.edgeTransforms[index].preRotate((float)Math.toDegrees(edgeAngle));
    }

    private void appendCornerPath(int index, Path path) {
        this.scratch[0] = this.cornerPaths[index].startX;
        this.scratch[1] = this.cornerPaths[index].startY;
        this.cornerTransforms[index].mapPoints(this.scratch);
        if (index == 0) {
            path.moveTo(this.scratch[0], this.scratch[1]);
        } else {
            path.lineTo(this.scratch[0], this.scratch[1]);
        }
        this.cornerPaths[index].applyToPath(this.cornerTransforms[index], path);
    }

    private void appendEdgePath(int index, Path path) {
        int nextIndex = (index + 1) % 4;
        this.scratch[0] = this.cornerPaths[index].endX;
        this.scratch[1] = this.cornerPaths[index].endY;
        this.cornerTransforms[index].mapPoints(this.scratch);
        this.scratch2[0] = this.cornerPaths[nextIndex].startX;
        this.scratch2[1] = this.cornerPaths[nextIndex].startY;
        this.cornerTransforms[nextIndex].mapPoints(this.scratch2);
        float edgeLength = (float)Math.hypot(this.scratch[0] - this.scratch2[0], this.scratch[1] - this.scratch2[1]);
        this.shapePath.reset(0.0f, 0.0f);
        this.getEdgeTreatmentForIndex(index).getEdgePath(edgeLength, this.interpolation, this.shapePath);
        this.shapePath.applyToPath(this.edgeTransforms[index], path);
    }

    private CornerTreatment getCornerTreatmentForIndex(int index) {
        switch (index) {
            case 1: {
                return this.shapedViewModel.getTopRightCorner();
            }
            case 2: {
                return this.shapedViewModel.getBottomRightCorner();
            }
            case 3: {
                return this.shapedViewModel.getBottomLeftCorner();
            }
        }
        return this.shapedViewModel.getTopLeftCorner();
    }

    private EdgeTreatment getEdgeTreatmentForIndex(int index) {
        switch (index) {
            case 1: {
                return this.shapedViewModel.getRightEdge();
            }
            case 2: {
                return this.shapedViewModel.getBottomEdge();
            }
            case 3: {
                return this.shapedViewModel.getLeftEdge();
            }
        }
        return this.shapedViewModel.getTopEdge();
    }

    private void getCoordinatesOfCorner(int index, int width, int height, PointF pointF) {
        switch (index) {
            case 1: {
                pointF.set((float)width, 0.0f);
                break;
            }
            case 2: {
                pointF.set((float)width, (float)height);
                break;
            }
            case 3: {
                pointF.set(0.0f, (float)height);
                break;
            }
            default: {
                pointF.set(0.0f, 0.0f);
            }
        }
    }

    private float angleOfCorner(int index, int width, int height) {
        this.getCoordinatesOfCorner((index - 1 + 4) % 4, width, height, this.pointF);
        float prevCornerCoordX = this.pointF.x;
        float prevCornerCoordY = this.pointF.y;
        this.getCoordinatesOfCorner((index + 1) % 4, width, height, this.pointF);
        float nextCornerCoordX = this.pointF.x;
        float nextCornerCoordY = this.pointF.y;
        this.getCoordinatesOfCorner(index, width, height, this.pointF);
        float cornerCoordX = this.pointF.x;
        float cornerCoordY = this.pointF.y;
        float prevVectorX = prevCornerCoordX - cornerCoordX;
        float prevVectorY = prevCornerCoordY - cornerCoordY;
        float nextVectorX = nextCornerCoordX - cornerCoordX;
        float nextVectorY = nextCornerCoordY - cornerCoordY;
        float prevAngle = (float)Math.atan2(prevVectorY, prevVectorX);
        float nextAngle = (float)Math.atan2(nextVectorY, nextVectorX);
        float angle = prevAngle - nextAngle;
        if (angle < 0.0f) {
            angle = (float)((double)angle + Math.PI * 2);
        }
        return angle;
    }

    private float angleOfEdge(int index, int width, int height) {
        int startCornerPosition = index;
        int endCornerPoisition = (index + 1) % 4;
        this.getCoordinatesOfCorner(startCornerPosition, width, height, this.pointF);
        float startCornerCoordX = this.pointF.x;
        float startCornerCoordY = this.pointF.y;
        this.getCoordinatesOfCorner(endCornerPoisition, width, height, this.pointF);
        float endCornerCoordX = this.pointF.x;
        float endCornerCoordY = this.pointF.y;
        float edgeVectorX = endCornerCoordX - startCornerCoordX;
        float edgeVectorY = endCornerCoordY - startCornerCoordY;
        return (float)Math.atan2(edgeVectorY, edgeVectorX);
    }

    private void getPath(int width, int height, Path path) {
        this.getPathForSize(width, height, path);
        if (this.scale == 1.0f) {
            return;
        }
        this.matrix.reset();
        this.matrix.setScale(this.scale, this.scale, (float)(width / 2), (float)(height / 2));
        path.transform(this.matrix);
    }

    private void updateTintFilter() {
        if (this.tintList == null || this.tintMode == null) {
            this.tintFilter = null;
            return;
        }
        int color2 = this.tintList.getColorForState(this.getState(), 0);
        this.tintFilter = new PorterDuffColorFilter(color2, this.tintMode);
        if (this.useTintColorForShadow) {
            this.shadowColor = color2;
        }
    }
}

