/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.StringRes;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManagerImpl;
import android.support.v4.app.FragmentTransaction;
import android.view.View;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.List;

public abstract class FragmentManager {
    public static final int POP_BACK_STACK_INCLUSIVE = 1;

    @NonNull
    public abstract FragmentTransaction beginTransaction();

    @Deprecated
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public FragmentTransaction openTransaction() {
        return this.beginTransaction();
    }

    public abstract boolean executePendingTransactions();

    @Nullable
    public abstract Fragment findFragmentById(@IdRes int var1);

    @Nullable
    public abstract Fragment findFragmentByTag(@Nullable String var1);

    public abstract void popBackStack();

    public abstract boolean popBackStackImmediate();

    public abstract void popBackStack(@Nullable String var1, int var2);

    public abstract boolean popBackStackImmediate(@Nullable String var1, int var2);

    public abstract void popBackStack(int var1, int var2);

    public abstract boolean popBackStackImmediate(int var1, int var2);

    public abstract int getBackStackEntryCount();

    @NonNull
    public abstract BackStackEntry getBackStackEntryAt(int var1);

    public abstract void addOnBackStackChangedListener(@NonNull OnBackStackChangedListener var1);

    public abstract void removeOnBackStackChangedListener(@NonNull OnBackStackChangedListener var1);

    public abstract void putFragment(@NonNull Bundle var1, @NonNull String var2, @NonNull Fragment var3);

    @Nullable
    public abstract Fragment getFragment(@NonNull Bundle var1, @NonNull String var2);

    @NonNull
    public abstract List<Fragment> getFragments();

    @Nullable
    public abstract Fragment.SavedState saveFragmentInstanceState(Fragment var1);

    public abstract boolean isDestroyed();

    public abstract void registerFragmentLifecycleCallbacks(@NonNull FragmentLifecycleCallbacks var1, boolean var2);

    public abstract void unregisterFragmentLifecycleCallbacks(@NonNull FragmentLifecycleCallbacks var1);

    @Nullable
    public abstract Fragment getPrimaryNavigationFragment();

    public abstract void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);

    public static void enableDebugLogging(boolean enabled) {
        FragmentManagerImpl.DEBUG = enabled;
    }

    public abstract boolean isStateSaved();

    public static abstract class FragmentLifecycleCallbacks {
        public void onFragmentPreAttached(@NonNull FragmentManager fm, @NonNull Fragment f, @NonNull Context context) {
        }

        public void onFragmentAttached(@NonNull FragmentManager fm, @NonNull Fragment f, @NonNull Context context) {
        }

        public void onFragmentPreCreated(@NonNull FragmentManager fm, @NonNull Fragment f, @Nullable Bundle savedInstanceState) {
        }

        public void onFragmentCreated(@NonNull FragmentManager fm, @NonNull Fragment f, @Nullable Bundle savedInstanceState) {
        }

        public void onFragmentActivityCreated(@NonNull FragmentManager fm, @NonNull Fragment f, @Nullable Bundle savedInstanceState) {
        }

        public void onFragmentViewCreated(@NonNull FragmentManager fm, @NonNull Fragment f, @NonNull View v, @Nullable Bundle savedInstanceState) {
        }

        public void onFragmentStarted(@NonNull FragmentManager fm, @NonNull Fragment f) {
        }

        public void onFragmentResumed(@NonNull FragmentManager fm, @NonNull Fragment f) {
        }

        public void onFragmentPaused(@NonNull FragmentManager fm, @NonNull Fragment f) {
        }

        public void onFragmentStopped(@NonNull FragmentManager fm, @NonNull Fragment f) {
        }

        public void onFragmentSaveInstanceState(@NonNull FragmentManager fm, @NonNull Fragment f, @NonNull Bundle outState) {
        }

        public void onFragmentViewDestroyed(@NonNull FragmentManager fm, @NonNull Fragment f) {
        }

        public void onFragmentDestroyed(@NonNull FragmentManager fm, @NonNull Fragment f) {
        }

        public void onFragmentDetached(@NonNull FragmentManager fm, @NonNull Fragment f) {
        }
    }

    public static interface OnBackStackChangedListener {
        public void onBackStackChanged();
    }

    public static interface BackStackEntry {
        public int getId();

        @Nullable
        public String getName();

        @StringRes
        public int getBreadCrumbTitleRes();

        @StringRes
        public int getBreadCrumbShortTitleRes();

        @Nullable
        public CharSequence getBreadCrumbTitle();

        @Nullable
        public CharSequence getBreadCrumbShortTitle();
    }
}

