#import <Foundation/Foundation.h>


@protocol fpBaseDelegate
-(void)deviceConnected;
-(void)deviceDisconnected;
@end

@interface fpBase : NSObject <NSStreamDelegate>
{
    uint8_t readBuf[256];
    int readLen;
    bool readThreadActive;
    bool readThreadShouldClose;
    
    int encoding;
    int mPacketSeq;
    NSInputStream *in;
    NSOutputStream *out;
    uint8_t _mSB[6];
    
    NSLock *memLock;
}

+(id)sharedInstance;
-(void)setEncoding:(int)newEncoding;
-(bool)connectWithStreams:(NSInputStream *)inStream outputStream:(NSOutputStream *)outStream error:(NSError **)error;
-(void)disconnect;

/**
 * Sends a custom command to the printer and returns the result
 * @param cmd - command number, refer to the documentation
 * @param data - optional additional data to the command, can be null
 * @return - command response
 * @throws IOException - raised upon communication error
 * @throws FiscalPrinterException - raised when there was a problem executing the command
 */
-(NSString *)customCommand:(int)cmd data:(NSString *)data error:(NSError **)error;

@property (readonly) bool streamConnected;
@property (readonly) bool deviceConnected;
@property (assign) id delegate;
@property (readonly) uint8_t *mSB;

@end
