//
//  FiscalPrinter.h
//  FiscalLibrary
//
//  Created by Flex on 3/27/13.
//  Copyright (c) 2013 Datecs. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface FiscalPrinter : NSObject

+(id)sharedInstance;

/**
 Allows unlimited delegates to be added to a single class instance. This is useful in the case of global
 class and every view can use addDelegate when the view is shown and removeDelegate when no longer needs to monitor events
 @param newDelegate the delegate that will be notified of Linea events
 **/
-(void)addDelegate:(id)newDelegate;

/**
 Removes delegate, previously added with addDelegate
 @param newDelegate the delegate that will be no longer be notified of Linea events
 **/
-(void)removeDelegate:(id)newDelegate;

-(bool)connectWithStreams:(NSInputStream *)inStream outputStream:(NSOutputStream *)outStream error:(NSError **)error;
-(void)disconnect;

/**
 Adds delegate to the class
 **/
@property(unsafe_unretained) id delegate;

/**
 Provides a list of currently registered delegates
 */
@property(readonly) NSMutableArray *delegates;

@property(readonly) bool deviceConnected;

/**
 * Sends a custom command to the printer and returns the result
 * @param cmd - command number, refer to the documentation
 * @param data - optional additional data to the command, can be null
 * @return - command response
 * @throws IOException - raised upon communication error
 * @throws FiscalPrinterException - raised when there was a problem executing the command
 */
-(NSString *)customCommand:(int)cmd data:(NSString *)data error:(NSError **)error;

/**
 Status bits - and array of 6 bytes
 */
@property (readonly) uint8_t *mSB;

@end
