//
//  DP25_ROU.h
//  FiscalLibrary
//
//  Created by Flex and Doba on 28.05.2013
//  Copyright (c) 2012 Datecs. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 Provides universal access to all supported devices' functions.
 In order to use one of the supported accessories in your program, several steps have to be performed:
 - Include DTDevices.h and libdtdev.a in your project.
 - Go to Frameworks and add ExternalAccessory framework
 - Edit your program plist file, add new element and select "Supported external accessory protocols" from the list, then add the protocol names of the accessories you want to connect to:
 <br>For Linea series: com.datecs.linea.pro.msr and com.datecs.linea.pro.bar
 <br>For Pinpad: com.datecs.iserial.communication and com.datecs.ppad
 <br>For iSerial: com.datecs.iserial.communication
 <br>For ESC/POS printers: com.datecs.printer.escpos
 <br>For Fiscal printers connected directly via bluetooth: com.datecs.printer.fiscal
 
 <br>Since this SDK is based on features, the specific device is not that important, for example, if your program relies on barcode scanning, then Linea, Pinpad or the ESC/POS printers can provide that functionality, so you can include all their protocols.
 */
@interface DP25_ROU : NSObject
{
    
}

+(id)sharedInstance;

/**
 Allows unlimited delegates to be added to a single class instance. This is useful in the case of global
 class and every view can use addDelegate when the view is shown and removeDelegate when no longer needs to monitor events
 @param newDelegate the delegate that will be notified of Linea events
 **/
-(void)addDelegate:(id)newDelegate;

/**
 Removes delegate, previously added with addDelegate
 @param newDelegate the delegate that will be no longer be notified of Linea events
 **/
-(void)removeDelegate:(id)newDelegate;

/**
 Connect to the fiscal device using streams
 */
-(bool)connectWithStreams:(NSInputStream *)inStream outputStream:(NSOutputStream *)outStream error:(NSError **)error;

/**
 Disconnects from the stream
 */
-(void)disconnect;

/**
 Adds delegate to the class
 **/
@property(unsafe_unretained) id delegate;

/**
 Provides a list of currently registered delegates
 */
@property(readonly) NSMutableArray *delegates;

@property(readonly) bool deviceConnected;
@property(readonly) int infoPrinterCodePage;
@property(readonly) int infoMajorNumberSDKVersion;
@property(readonly) int infoMinorNumberSDKVersion;
@property(readonly) int infoReleaseNumberSDKVersion;
@property(readonly) int infoBuildNumberSDKVersion;
@property(readonly) int infoMaxLogoHigh;
@property(readonly) int infoMaxLogoWidth;
@property(readonly) int infoMaxHeaderLinesCount;
@property(readonly) int infoMaxFooterLinesCount;
@property(readonly) int infoMaxTransactionsCountInFiscalReceipt;
@property(readonly) int infoMaxSymbolCountInSellTextRow1;
@property(readonly) int infoMaxSymbolCountInSellTextRow2;
@property(readonly) int infoMaxSymbolCountInNonFiscalText;
@property(readonly) int infoMaxSymbolCountInNonFiscalRotatedText;
@property(readonly) int infoMaxSymbolCountInFiscalText;
@property(readonly) int infoMaxDepartmentCount;
@property(readonly) int infoMaxItemsCount;
@property(readonly) int infoTaxRatesMaxCount;
@property(readonly) int infoDisplayCodePage;
@property(readonly) int infoLastClassErrorCode;
@property(readonly) bool infoMandatoryZReportEndOfDay;
@property(readonly) bool infoMandatoryEKLPrintBeforeZReport;
@property(readonly) bool infoMandatoryEKLSave;
@property(readonly) bool infoMandatoryMonthlyReport;
@property(readonly) bool infoMandatoryYearlyReport;
@property(readonly) bool statusDisplayNotConnected;
@property(readonly) bool statusTransparentDisplayMode;
@property(readonly) bool statusFiscalMemoryMissing;
@property(readonly) bool statusPrintingHeadOverheated;
@property(readonly) bool statusSeconRollNoPaperPlace;
@property(readonly) bool statusSeconRollOutOfPaper;
@property(readonly) bool statusEndOfEKL;
@property(readonly) bool statusDrawerOpened;
@property(readonly) bool statusEKLNotEmpty;
@property(readonly) bool statusEKLPrinted;
@property(readonly) bool statusEKLNearEnd;
@property(readonly) bool statusKLENNearEnd;
@property(readonly) bool statusSecondRollNotEnoughPaper;
@property(readonly) bool statusAutomaticPaperCutting;
@property(readonly) bool statusPrintingHeadNotConnected;
@property(readonly) bool supportEKL;
@property(readonly) bool supportNRATerminal;
@property(readonly) bool supportKLEN;
@property(readonly) bool supportEIK;
@property(readonly) bool supportServiceContractsInformation;
@property(readonly) bool supportIOSANumber;
@property(readonly) bool supportFiscalReceipts;
@property(readonly) bool supportRotatedFiscalReceipts;
@property(readonly) bool supportNonFiscalReceipts;
@property(readonly) bool supportRotatedNonFiscalReceipts;
@property(readonly) bool supportBluetooth;
@property(readonly) bool supportWiFi;
@property(readonly) bool supportTCPIP;
@property(readonly) bool supportFTP;
@property(readonly) bool supportHTTP;
@property(readonly) bool supportSoftwareSwitches;
@property(readonly) bool supportClientDisplay;
@property(readonly) bool supportDrawerOpening;
@property(readonly) bool supportDrawerStatus;
@property(readonly) bool supportSecondRoll;
@property(readonly) bool supportAutoCutPaper;
@property(readonly) bool supportAdditionalMatrixPrint;
@property(readonly) bool supportPrintingHeadTemperatureControl;
@property(readonly) bool supportAsynchronousMode;
@property(readonly) bool supportTransactionsBufferForCommands;
@property(readonly) bool supportReceiptVoid;
@property(readonly) bool supportSaleRowVoid;
@property(readonly) bool supportVoidReceipt;
@property(readonly) bool supportVoidSale;
@property(readonly) bool statusEIKSet;
@property(readonly) bool statusSerialNumberSet;
@property(readonly) bool statusFMNumberSet;
@property(readonly) bool statusPrinterFiscalized;
@property(readonly) bool statusFiscalMemoryFormated;
@property(readonly) bool statusTaxRatesOk;
@property(readonly) bool statusLowBattery;
@property(readonly) bool statusGeneralErrorType1;
@property(readonly) bool statusGeneralErrorType2;
@property(readonly) bool statusPrintingHeadFailure;
@property(readonly) bool statusPrinterClockNotSet;
@property(readonly) bool statusInvalidCommand;
@property(readonly) bool statusSyntaxError;
@property(readonly) bool statusNRATerminalNotRespond;
@property(readonly) bool statusRamError;
@property(readonly) bool statusRamCleared;
@property(readonly) bool statusCommandNotAllowed;
@property(readonly) bool statusFieldOverflow;
@property(readonly) bool statusFiscalMemoryFull;
@property(readonly) bool statusFiscalMemoryReadError;
@property(readonly) bool statusFiscalMemoryWriteError;
@property(readonly) bool statusFiscalMemoryReadOnly;
@property(readonly) bool statusOutOfPaper;
@property(readonly) bool statusEndOfKLEN;
@property(readonly) bool statusFiscalReceiptOpened;
@property(readonly) bool statusNonFiscalReceiptOpened;
@property(readonly) bool statusRotatedReceiptOpened;
@property(readonly) bool statusFiscalMemoryNearEnd;
@property(readonly) bool statusCoverWasOpened;
@property(readonly) bool statusNotEnoughPaper;
@property(readonly) NSString *infoTaxEnabledArray;
@property(readonly) NSString *infoServiceEIKNumber;
@property(readonly) NSString *infoServiceEndDate;
@property(readonly) NSString *infoPrinterName;
@property(readonly) NSString *infoFirmwareRevision;
@property(readonly) NSString *infoFirmwareDateTime;
@property(readonly) NSString *infoSerialNumber;
@property(readonly) NSString *infoFiscalModuleNumber;
@property(readonly) bool infoBluetoothDiscoverable;
@property(readonly) NSString *infoMACAddress;
@property(readonly) NSString *infoIPAddress;
@property(readonly) NSString *infoIOSANumber;
@property(readonly) NSString *infoTaxArray;
@property(readonly) NSString *infoLastErrorText;
@property(copy) NSString *sellParameterTextRow1;
@property(copy) NSString *sellParameterTextRow2;
@property(copy) NSString *sellParameterTaxGroup;
@property(copy) NSString *sellParameterSpecialTax;
@property(copy) NSString *sellParameterPrice;
@property(copy) NSString *sellParameterQuantity;
@property(copy) NSString *sellParameterPLU;
@property(copy) NSString *sellParameterDepartment;
@property(copy) NSString *sellParameterPercent;
@property(copy) NSString *sellParameterAbsoluteSum;
@property(copy) NSString *sellParameterOperatorCode;
@property(copy) NSString *sellParameterOperatorPassword;
@property(copy) NSString *sellParameterOperatorTillNumber;
@property(copy) NSString *subtotalParameterToPrint;
@property(copy) NSString *subtotalParameterPercent;
@property(copy) NSString *subtotalParameterAbsoluteSum;
@property(copy) NSString *totalParameterTextRow1;
@property(copy) NSString *totalParameterTextRow2;
@property(copy) NSString *totalParameterPaidMode;
@property(copy) NSString *totalParameterAmount;





/* machine-oriented interface begin */

    -(bool)command33Variant0Version0AndReturnError:(NSError **)error;
    -(bool)command35Variant0Version0InputText:(NSString *)inputText error:(NSError **)error;
    -(NSDictionary *)command38Variant0Version0AndReturnError:(NSError **)error;
    -(NSDictionary *)command39Variant0Version0AndReturnError:(NSError **)error;
    -(bool)command42Variant0Version0InputText:(NSString *)inputText error:(NSError **)error;
    -(bool)command43Variant0Version0ItemIndex:(NSString *)itemIndex dataValue:(NSString *)dataValue error:(NSError **)error;
    -(bool)command44Variant0Version0TargetLines:(NSString *)targetLines error:(NSError **)error;
    -(bool)command47Variant0Version0InputText:(NSString *)inputText error:(NSError **)error;
    -(NSDictionary *)command48Variant0Version0OperatorCode:(NSString *)operatorCode operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber error:(NSError **)error;
    -(bool)command49Variant0Version0TaxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice error:(NSError **)error;
    -(bool)command49Variant0Version2TaxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity error:(NSError **)error;
    -(bool)command49Variant0Version4TextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice error:(NSError **)error;
    -(bool)command49Variant0Version6TextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity error:(NSError **)error;
    -(bool)command49Variant0Version8TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice error:(NSError **)error;
    -(bool)command49Variant0Version10TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity error:(NSError **)error;
    -(bool)command49Variant0Version12TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice error:(NSError **)error;
    -(bool)command49Variant0Version14TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity error:(NSError **)error;
    -(bool)command49Variant1Version0TaxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
    -(bool)command49Variant1Version2TaxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
    -(bool)command49Variant1Version4TextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
    -(bool)command49Variant1Version6TextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
    -(bool)command49Variant1Version8TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
    -(bool)command49Variant1Version10TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
    -(bool)command49Variant1Version12TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
    -(bool)command49Variant1Version14TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
    -(bool)command49Variant2Version0TaxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
    -(bool)command49Variant2Version2TaxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
    -(bool)command49Variant2Version4TextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
    -(bool)command49Variant2Version6TextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
    -(bool)command49Variant2Version8TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
    -(bool)command49Variant2Version10TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
    -(bool)command49Variant2Version12TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
    -(bool)command49Variant2Version14TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
    -(NSDictionary *)command50Variant0Version0StartDate:(NSString *)startDate endDate:(NSString *)endDate error:(NSError **)error;
    -(NSDictionary *)command51Variant0Version0AndReturnError:(NSError **)error;
    -(NSDictionary *)command51Variant0Version1SubtotalWithPercentDiscount:(NSString *)subtotalWithPercentDiscount error:(NSError **)error;
    -(NSDictionary *)command51Variant0Version2SubtotalWithAbsoluteSumDiscount:(NSString *)subtotalWithAbsoluteSumDiscount error:(NSError **)error;
    -(NSDictionary *)command53Variant0Version0PaidMode:(NSString *)paidMode amountIn:(NSString *)amountIn error:(NSError **)error;
    -(NSDictionary *)command53Variant0Version1TextRow2:(NSString *)textRow2 paidMode:(NSString *)paidMode amountIn:(NSString *)amountIn error:(NSError **)error;
    -(NSDictionary *)command53Variant0Version2TextRow1:(NSString *)textRow1 paidMode:(NSString *)paidMode amountIn:(NSString *)amountIn error:(NSError **)error;
    -(NSDictionary *)command53Variant0Version4TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 paidMode:(NSString *)paidMode amountIn:(NSString *)amountIn error:(NSError **)error;
    -(NSDictionary *)command53Variant1Version0AndReturnError:(NSError **)error;
    -(NSDictionary *)command53Variant1Version1TextRow2:(NSString *)textRow2 error:(NSError **)error;
    -(NSDictionary *)command53Variant1Version2TextRow1:(NSString *)textRow1 error:(NSError **)error;
    -(NSDictionary *)command53Variant1Version3TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 error:(NSError **)error;
    -(bool)command54Variant0Version0InputText:(NSString *)inputText error:(NSError **)error;
    -(NSDictionary *)command56Variant0Version0AndReturnError:(NSError **)error;
    -(bool)command60Variant0Version0AndReturnError:(NSError **)error;
    -(bool)command61Variant0Version0TargetDate:(NSString *)targetDate targetTime:(NSString *)targetTime error:(NSError **)error;
    -(NSDictionary *)command62Variant0Version0AndReturnError:(NSError **)error;
    -(bool)command63Variant0Version0AndReturnError:(NSError **)error;
    -(NSDictionary *)command64Variant0Version0AndReturnError:(NSError **)error;
    -(NSDictionary *)command65Variant0Version0AndReturnError:(NSError **)error;
    -(NSDictionary *)command68Variant0Version0AndReturnError:(NSError **)error;
    -(NSDictionary *)command69Variant0Version0ReportTypeOption:(NSString *)reportTypeOption error:(NSError **)error;
    -(NSDictionary *)command70Variant0Version0AmountInOut:(NSString *)amountInOut error:(NSError **)error;
    -(NSDictionary *)command70Variant0Version1AndReturnError:(NSError **)error;
    -(bool)command71Variant0Version0AndReturnError:(NSError **)error;
    -(bool)command73Variant0Version0StartRecordNumber:(NSString *)startRecordNumber endRecordNumber:(NSString *)endRecordNumber error:(NSError **)error;
    -(NSDictionary *)command74Variant0Version0AndReturnError:(NSError **)error;
    -(NSDictionary *)command74Variant1Version0AndReturnError:(NSError **)error;
    -(NSDictionary *)command76Variant0Version0AndReturnError:(NSError **)error;
    -(bool)command79Variant0Version0StartDate:(NSString *)startDate endDate:(NSString *)endDate error:(NSError **)error;
    -(bool)command80Variant0Version0SoundData:(NSString *)soundData error:(NSError **)error;
    -(NSDictionary *)command83Variant0Version0InputMultiplier:(NSString *)inputMultiplier inputDecimals:(NSString *)inputDecimals inputCurrency:(NSString *)inputCurrency inputEnabledTaxesArray:(NSString *)inputEnabledTaxesArray inputTaxGroupA:(NSString *)inputTaxGroupA inputTaxGroupB:(NSString *)inputTaxGroupB inputTaxGroupC:(NSString *)inputTaxGroupC inputTaxGroupD:(NSString *)inputTaxGroupD inputTaxGroupE:(NSString *)inputTaxGroupE inputTaxGroupF:(NSString *)inputTaxGroupF inputTaxGroupG:(NSString *)inputTaxGroupG error:(NSError **)error;
    -(NSDictionary *)command83Variant1Version0AndReturnError:(NSError **)error;
    -(NSDictionary *)command85Variant0Version0AdditionalPaymentTypeOption:(NSString *)additionalPaymentTypeOption inputAdditionalPaymentName:(NSString *)inputAdditionalPaymentName error:(NSError **)error;
    -(NSDictionary *)command85Variant0Version1AdditionalPaymentTypeOption:(NSString *)additionalPaymentTypeOption error:(NSError **)error;
    -(NSDictionary *)command86Variant0Version0AndReturnError:(NSError **)error;
    -(NSDictionary *)command90Variant0Version0AndReturnError:(NSError **)error;
    -(bool)command92Variant0Version0LineType:(NSString *)lineType error:(NSError **)error;
    -(bool)command94Variant0Version0StartDate:(NSString *)startDate endDate:(NSString *)endDate error:(NSError **)error;
    -(bool)command95Variant0Version0StartFiscalRecordNumber:(NSString *)startFiscalRecordNumber endFiscalRecordNumber:(NSString *)endFiscalRecordNumber error:(NSError **)error;
    -(NSDictionary *)command97Variant0Version0AndReturnError:(NSError **)error;
    -(NSDictionary *)command99Variant0Version0AndReturnError:(NSError **)error;
    -(bool)command100Variant0Version0InputText:(NSString *)inputText error:(NSError **)error;
    -(bool)command101Variant0Version0OperatorCode:(NSString *)operatorCode oldOperatorPassword:(NSString *)oldOperatorPassword newOperatorPassword:(NSString *)newOperatorPassword error:(NSError **)error;
    -(bool)command102Variant0Version0OperatorCode:(NSString *)operatorCode operatorPassword:(NSString *)operatorPassword operatorName:(NSString *)operatorName error:(NSError **)error;
    -(NSDictionary *)command103Variant0Version0AndReturnError:(NSError **)error;
    -(bool)command105Variant0Version0AndReturnError:(NSError **)error;
    -(bool)command106Variant0Version0MSec:(NSString *)mSec error:(NSError **)error;
    -(NSDictionary *)command108Variant0Version0ReportTypeOption:(NSString *)reportTypeOption error:(NSError **)error;
    -(bool)command109Variant0Version0ReceiptCount:(NSString *)receiptCount error:(NSError **)error;
    -(NSDictionary *)command110Variant0Version0AndReturnError:(NSError **)error;
    -(NSDictionary *)command111Variant0Version0PrintOption:(NSString *)printOption startItemNumber:(NSString *)startItemNumber endItemNumber:(NSString *)endItemNumber error:(NSError **)error;
    -(NSDictionary *)command111Variant1Version0PrintOption:(NSString *)printOption startItemNumber:(NSString *)startItemNumber endItemNumber:(NSString *)endItemNumber itemGroup:(NSString *)itemGroup error:(NSError **)error;
    -(NSDictionary *)command111Variant2Version0PrintOption:(NSString *)printOption error:(NSError **)error;
    -(NSDictionary *)command112Variant0Version0OperatorCode:(NSString *)operatorCode error:(NSError **)error;
    -(NSDictionary *)command113Variant0Version0AndReturnError:(NSError **)error;
    -(NSDictionary *)command114Variant0Version0FiscalRecordNumber:(NSString *)fiscalRecordNumber error:(NSError **)error;
    -(NSDictionary *)command114Variant1Version0FiscalRecordNumber:(NSString *)fiscalRecordNumber error:(NSError **)error;
    -(NSDictionary *)command114Variant1Version1FiscalRecordNumber1:(NSString *)fiscalRecordNumber1 fiscalRecordNumber2:(NSString *)fiscalRecordNumber2 error:(NSError **)error;
    -(NSDictionary *)command114Variant2Version0FiscalRecordNumber:(NSString *)fiscalRecordNumber error:(NSError **)error;
    -(NSDictionary *)command114Variant2Version1FiscalRecordNumber1:(NSString *)fiscalRecordNumber1 fiscalRecordNumber2:(NSString *)fiscalRecordNumber2 error:(NSError **)error;
    -(NSDictionary *)command114Variant3Version0FiscalRecordNumber:(NSString *)fiscalRecordNumber error:(NSError **)error;
    -(NSDictionary *)command114Variant3Version1FiscalRecordNumber1:(NSString *)fiscalRecordNumber1 fiscalRecordNumber2:(NSString *)fiscalRecordNumber2 error:(NSError **)error;
    -(NSDictionary *)command114Variant4Version0FiscalRecordNumber:(NSString *)fiscalRecordNumber error:(NSError **)error;
    -(NSDictionary *)command114Variant5Version0FiscalRecordNumber:(NSString *)fiscalRecordNumber error:(NSError **)error;
    -(NSDictionary *)command114Variant6Version0FiscalRecordNumber:(NSString *)fiscalRecordNumber error:(NSError **)error;
    -(bool)command115Variant0Version0RowNumber:(NSString *)rowNumber rowData:(NSString *)rowData error:(NSError **)error;
    -(NSDictionary *)command115Variant1Version0RowNumber:(NSString *)rowNumber error:(NSError **)error;


/* machine-oriented interface end */

/* human-oriented interface - begin */
-(bool)checkAndResolveAndReturnError:(NSError **)error;
/* human-oriented interface - end */

@end